/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreManager;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.jackson.api.TimefoldJacksonModule;
import ai.timefold.solver.spring.boot.autoconfigure.TimefoldSolverAutoConfiguration;
import ai.timefold.solver.spring.boot.autoconfigure.TimefoldSolverBannerBean;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverManagerProperties;
import ai.timefold.solver.spring.boot.autoconfigure.config.TimefoldProperties;
import ai.timefold.solver.test.api.score.stream.ConstraintVerifier;
import ai.timefold.solver.test.api.score.stream.MultiConstraintVerification;
import ai.timefold.solver.test.api.score.stream.SingleConstraintVerification;
import com.fasterxml.jackson.databind.Module;
import java.util.function.BiFunction;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class TimefoldSolverBeanFactory
implements ApplicationContextAware,
EnvironmentAware {
    private ApplicationContext context;
    private TimefoldProperties timefoldProperties;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setEnvironment(Environment environment) {
        BindResult result = Binder.get((Environment)environment).bind("timefold", TimefoldProperties.class);
        this.timefoldProperties = (TimefoldProperties)result.orElseGet(TimefoldProperties::new);
    }

    private void failInjectionWithMultipleSolvers(String resourceName) {
        if (this.timefoldProperties.getSolver() != null && this.timefoldProperties.getSolver().size() > 1) {
            throw new BeanCreationException("No qualifying bean of type '%s' available".formatted(resourceName));
        }
    }

    @Bean
    @Lazy
    public TimefoldSolverBannerBean getBanner() {
        return new TimefoldSolverBannerBean();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public <Solution_> SolverFactory<Solution_> getSolverFactory() {
        this.failInjectionWithMultipleSolvers(SolverFactory.class.getName());
        SolverConfig solverConfig = (SolverConfig)this.context.getBean(SolverConfig.class);
        if (solverConfig.getSolutionClass() == null) {
            return null;
        }
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> solverManager(SolverFactory solverFactory) {
        if (solverFactory == null) {
            return null;
        }
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        SolverManagerProperties solverManagerProperties = this.timefoldProperties.getSolverManager();
        if (solverManagerProperties != null && solverManagerProperties.getParallelSolverCount() != null) {
            solverManagerConfig.setParallelSolverCount(solverManagerProperties.getParallelSolverCount());
        }
        return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    @Deprecated(forRemoval=true)
    public <Solution_, Score_ extends Score<Score_>> ScoreManager<Solution_, Score_> scoreManager() {
        this.failInjectionWithMultipleSolvers(ScoreManager.class.getName());
        SolverFactory solverFactory = (SolverFactory)this.context.getBean(SolverFactory.class);
        return ScoreManager.create((SolverFactory)solverFactory);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public <Solution_, Score_ extends Score<Score_>> SolutionManager<Solution_, Score_> solutionManager() {
        this.failInjectionWithMultipleSolvers(SolutionManager.class.getName());
        SolverFactory solverFactory = (SolverFactory)this.context.getBean(SolverFactory.class);
        return SolutionManager.create((SolverFactory)solverFactory);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public <Solution_> ConstraintMetaModel constraintMetaModel() {
        this.failInjectionWithMultipleSolvers(ConstraintMetaModel.class.getName());
        DefaultSolverFactory solverFactory = (DefaultSolverFactory)this.context.getBean(SolverFactory.class);
        InnerScoreDirectorFactory scoreDirectorFactory = solverFactory.getScoreDirectorFactory();
        if (scoreDirectorFactory instanceof AbstractConstraintStreamScoreDirectorFactory) {
            AbstractConstraintStreamScoreDirectorFactory castScoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)scoreDirectorFactory;
            return castScoreDirectorFactory.getConstraintMetaModel();
        }
        throw new IllegalStateException("Cannot provide %s because the score director does not use the Constraint Streams API.".formatted(ConstraintMetaModel.class.getSimpleName()));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, Score.class})
    static class TimefoldJacksonConfiguration {
        TimefoldJacksonConfiguration() {
        }

        @Bean
        Module jacksonModule() {
            return TimefoldJacksonModule.createModule();
        }
    }

    @ConditionalOnClass(value={ConstraintVerifier.class})
    @ConditionalOnMissingBean(value={ConstraintVerifier.class})
    @AutoConfigureAfter(value={TimefoldSolverAutoConfiguration.class})
    class TimefoldConstraintVerifierConfiguration {
        private final ApplicationContext context;

        protected TimefoldConstraintVerifierConfiguration(ApplicationContext context) {
            this.context = context;
        }

        @Bean
        @Lazy
        <ConstraintProvider_ extends ConstraintProvider, SolutionClass_> ConstraintVerifier<ConstraintProvider_, SolutionClass_> constraintVerifier() {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig;
            SolverConfig solverConfig;
            TimefoldSolverBeanFactory.this.failInjectionWithMultipleSolvers(ConstraintProvider.class.getName());
            try {
                solverConfig = (SolverConfig)this.context.getBean(SolverConfig.class);
            }
            catch (BeansException exception) {
                solverConfig = null;
            }
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig2 = scoreDirectorFactoryConfig = solverConfig != null ? solverConfig.getScoreDirectorFactoryConfig() : null;
            if (scoreDirectorFactoryConfig == null || scoreDirectorFactoryConfig.getConstraintProviderClass() == null) {
                String noConstraintProviderErrorMsg = scoreDirectorFactoryConfig != null ? "Cannot provision a ConstraintVerifier because there is no ConstraintProvider class." : "Cannot provision a ConstraintVerifier because there is no PlanningSolution or PlanningEntity classes.";
                return new UnsupportedConstraintVerifier(noConstraintProviderErrorMsg);
            }
            return ConstraintVerifier.create((SolverConfig)solverConfig);
        }

        private record UnsupportedConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, SolutionClass_>(String errorMessage) implements ConstraintVerifier<ConstraintProvider_, SolutionClass_>
        {
            public @NonNull SingleConstraintVerification<SolutionClass_> verifyThat(@NonNull BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
                throw new UnsupportedOperationException(this.errorMessage);
            }

            public @NonNull MultiConstraintVerification<SolutionClass_> verifyThat() {
                throw new UnsupportedOperationException(this.errorMessage);
            }
        }
    }
}

