/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.jackson.it;

import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.quarkus.jackson.it.domain.ITestdataPlanningSolution;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.concurrent.ExecutionException;

@Path(value="/timefold/test")
public class TimefoldTestResource {
    private final SolverManager<ITestdataPlanningSolution, Long> solverManager;

    @Inject
    public TimefoldTestResource(SolverManager<ITestdataPlanningSolution, Long> solverManager) {
        this.solverManager = solverManager;
    }

    @POST
    @Path(value="/solver-factory")
    public ITestdataPlanningSolution solveWithSolverFactory(ITestdataPlanningSolution problem) {
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)problem);
        try {
            return (ITestdataPlanningSolution)solverJob.getFinalBestSolution();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Solving was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }
}

