/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.quarkus;

import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.benchmark.quarkus.config.TimefoldBenchmarkRuntimeConfig;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class TimefoldBenchmarkRecorder {
    public Supplier<PlannerBenchmarkConfig> benchmarkConfigSupplier(PlannerBenchmarkConfig benchmarkConfig, TimefoldBenchmarkRuntimeConfig timefoldRuntimeConfig) {
        return () -> {
            SolverConfig solverConfig = (SolverConfig)Arc.container().instance(SolverConfig.class, new Annotation[0]).get();
            if (benchmarkConfig != null && benchmarkConfig.getSolverBenchmarkConfigList() == null && timefoldRuntimeConfig != null && timefoldRuntimeConfig.termination() != null) {
                benchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
            }
            return this.updateBenchmarkConfigWithRuntimeProperties(benchmarkConfig, timefoldRuntimeConfig, solverConfig);
        };
    }

    private PlannerBenchmarkConfig updateBenchmarkConfigWithRuntimeProperties(PlannerBenchmarkConfig plannerBenchmarkConfig, TimefoldBenchmarkRuntimeConfig benchmarkRuntimeConfig, SolverConfig solverConfig) {
        TerminationConfig inheritedTerminationConfig;
        if (plannerBenchmarkConfig == null) {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
        }
        if (benchmarkRuntimeConfig != null && benchmarkRuntimeConfig.resultDirectory() != null) {
            plannerBenchmarkConfig.setBenchmarkDirectory(new File(benchmarkRuntimeConfig.resultDirectory()));
        }
        SolverBenchmarkConfig inheritedBenchmarkConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig();
        if (plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() != null) {
            if (inheritedBenchmarkConfig == null) {
                inheritedBenchmarkConfig = new SolverBenchmarkConfig();
                plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(inheritedBenchmarkConfig);
                inheritedBenchmarkConfig.setSolverConfig(solverConfig.copyConfig());
            }
            if (inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig() != null) {
                inheritedTerminationConfig = inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig();
            } else {
                inheritedTerminationConfig = new TerminationConfig();
                inheritedBenchmarkConfig.getSolverConfig().setTerminationConfig(inheritedTerminationConfig);
            }
            if (benchmarkRuntimeConfig != null && benchmarkRuntimeConfig.termination() != null) {
                benchmarkRuntimeConfig.termination().spentLimit().ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setSpentLimit(arg_0));
                benchmarkRuntimeConfig.termination().unimprovedSpentLimit().ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setUnimprovedSpentLimit(arg_0));
                benchmarkRuntimeConfig.termination().bestScoreLimit().ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setBestScoreLimit(arg_0));
            }
        }
        inheritedTerminationConfig = null;
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig() != null) {
            inheritedTerminationConfig = inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig();
        }
        if (inheritedTerminationConfig == null || !inheritedTerminationConfig.isConfigured()) {
            List solverBenchmarkConfigList = plannerBenchmarkConfig.getSolverBenchmarkConfigList();
            if (solverBenchmarkConfigList == null) {
                throw new IllegalStateException("At least one of the properties quarkus.timefold.benchmark.solver.termination.spent-limit, quarkus.timefold.benchmark.solver.termination.best-score-limit, quarkus.timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in the inherited solver benchmark config and solverBenchmarkBluePrint is used.");
            }
            for (SolverBenchmarkConfig solverBenchmarkConfig : solverBenchmarkConfigList) {
                SolverConfig solverConfig_ = Objects.requireNonNullElseGet(solverBenchmarkConfig.getSolverConfig(), SolverConfig::new);
                solverBenchmarkConfig.setSolverConfig(solverConfig_);
                TerminationConfig terminationConfig = solverConfig_.getTerminationConfig();
                if (terminationConfig == null) {
                    terminationConfig = new TerminationConfig();
                    solverConfig_.setTerminationConfig(terminationConfig);
                } else if (terminationConfig.isConfigured()) continue;
                if (benchmarkRuntimeConfig != null && benchmarkRuntimeConfig.termination() != null) {
                    benchmarkRuntimeConfig.termination().spentLimit().ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
                    benchmarkRuntimeConfig.termination().unimprovedSpentLimit().ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
                    benchmarkRuntimeConfig.termination().bestScoreLimit().ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
                }
                if (terminationConfig.isConfigured() || solverConfig_.canTerminate()) continue;
                throw new IllegalStateException("At least one of the solver benchmarks is not configured to terminate. At least one of the properties quarkus.timefold.benchmark.solver.termination.spent-limit, quarkus.timefold.benchmark.solver.termination.best-score-limit, quarkus.timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in a solver benchmark and the inherited solver benchmark config.");
            }
        }
        if (plannerBenchmarkConfig.getSolverBenchmarkConfigList() != null) {
            for (SolverBenchmarkConfig childBenchmarkConfig : plannerBenchmarkConfig.getSolverBenchmarkConfigList()) {
                if (childBenchmarkConfig.getSolverConfig() == null) {
                    childBenchmarkConfig.setSolverConfig(new SolverConfig());
                }
                this.inheritPropertiesFromSolverConfig(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig);
            }
        }
        if (plannerBenchmarkConfig.getSolverBenchmarkConfigList() == null && plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() == null) {
            plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        }
        return plannerBenchmarkConfig;
    }

    private void inheritPropertiesFromSolverConfig(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig) {
        this.inheritProperty(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig, SolverConfig::getSolutionClass, SolverConfig::setSolutionClass);
        this.inheritProperty(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig, SolverConfig::getEntityClassList, SolverConfig::setEntityClassList);
        this.inheritScoreCalculation(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig);
    }

    private <T> void inheritProperty(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig, Function<SolverConfig, T> getter, BiConsumer<SolverConfig, T> setter) {
        if (getter.apply(childBenchmarkConfig.getSolverConfig()) != null) {
            return;
        }
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && getter.apply(inheritedBenchmarkConfig.getSolverConfig()) != null) {
            return;
        }
        setter.accept(childBenchmarkConfig.getSolverConfig(), (SolverConfig)getter.apply(solverConfig));
    }

    private void inheritScoreCalculation(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig) {
        if (this.isScoreCalculationDefined(childBenchmarkConfig.getSolverConfig())) {
            return;
        }
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && this.isScoreCalculationDefined(inheritedBenchmarkConfig.getSolverConfig())) {
            return;
        }
        ScoreDirectorFactoryConfig childScoreDirectorFactoryConfig = Objects.requireNonNull(childBenchmarkConfig.getSolverConfig()).getScoreDirectorFactoryConfig();
        ScoreDirectorFactoryConfig inheritedScoreDirectorFactoryConfig = Objects.requireNonNull(solverConfig.getScoreDirectorFactoryConfig());
        if (childScoreDirectorFactoryConfig == null) {
            childScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            Objects.requireNonNull(childBenchmarkConfig.getSolverConfig()).setScoreDirectorFactoryConfig(childScoreDirectorFactoryConfig);
        }
        childScoreDirectorFactoryConfig.inherit(inheritedScoreDirectorFactoryConfig);
    }

    private boolean isScoreCalculationDefined(SolverConfig solverConfig) {
        if (solverConfig == null) {
            return false;
        }
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        if (scoreDirectorFactoryConfig == null) {
            return false;
        }
        return scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() != null || scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() != null || scoreDirectorFactoryConfig.getConstraintProviderClass() != null;
    }
}

