/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.migration.v8;

import ai.timefold.solver.migration.AbstractRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.Recipe;
import org.openrewrite.java.ChangeAnnotationAttributeName;
import org.openrewrite.java.ChangeMethodName;

public final class NullableRecipe
extends AbstractRecipe {
    public String getDisplayName() {
        return "PlanningVariable's `nullable` is newly called `unassignedValues`";
    }

    public String getDescription() {
        return "Removes references to null vars and replace them with unassigned values.";
    }

    public List<Recipe> getRecipeList() {
        String packageName = "ai.timefold.solver.core.api.score.stream";
        Map<String, String> methodsToRename = Map.ofEntries(Map.entry("ConstraintFactory forEachIncludingNullVars(Class)", "forEachIncludingUnassigned"), Map.entry("uni.UniConstraintStream ifExistsIncludingNullVars(..)", "ifExistsIncludingUnassigned"), Map.entry("uni.UniConstraintStream ifExistsOtherIncludingNullVars(..)", "ifExistsOtherIncludingUnassigned"), Map.entry("uni.UniConstraintStream ifNotExistsIncludingNullVars(..)", "ifNotExistsIncludingUnassigned"), Map.entry("uni.UniConstraintStream ifNotExistsOtherIncludingNullVars(..)", "ifNotExistsOtherIncludingUnassigned"), Map.entry("bi.BiConstraintStream ifExistsIncludingNullVars(..)", "ifExistsIncludingUnassigned"), Map.entry("bi.BiConstraintStream ifNotExistsIncludingNullVars(..)", "ifNotExistsIncludingUnassigned"), Map.entry("tri.TriConstraintStream ifExistsIncludingNullVars(..)", "ifExistsIncludingUnassigned"), Map.entry("tri.TriConstraintStream ifNotExistsIncludingNullVars(..)", "ifNotExistsIncludingUnassigned"), Map.entry("quad.QuadConstraintStream ifExistsIncludingNullVars(..)", "ifExistsIncludingUnassigned"), Map.entry("quad.QuadConstraintStream ifNotExistsIncludingNullVars(..)", "ifNotExistsIncludingUnassigned"));
        ArrayList<Recipe> result = new ArrayList<Recipe>();
        methodsToRename.forEach((oldPattern, newMethodName) -> {
            String pattern = packageName + "." + oldPattern;
            result.add((Recipe)new ChangeMethodName(pattern, newMethodName, null, null));
        });
        result.add((Recipe)new ChangeAnnotationAttributeName("ai.timefold.solver.core.api.domain.variable.PlanningVariable", "nullable", "allowsUnassigned"));
        return result;
    }
}

