/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jackson.api.score.analysis;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractScoreAnalysisJacksonDeserializer<Score_ extends Score<Score_>>
extends JsonDeserializer<ScoreAnalysis<Score_>> {
    public final ScoreAnalysis<Score_> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Score_ score = this.parseScore(node.get("score").asText());
        HashMap<ConstraintRef, ConstraintAnalysis> constraintAnalysisList = new HashMap<ConstraintRef, ConstraintAnalysis>();
        for (JsonNode constraintNode : node.get("constraints")) {
            String constraintPackage = constraintNode.get("package").asText();
            String constraintName = constraintNode.get("name").asText();
            ConstraintRef constraintRef = ConstraintRef.of((String)constraintPackage, (String)constraintName);
            Score_ constraintWeight = this.parseScore(constraintNode.get("weight").asText());
            Score_ constraintScore = this.parseScore(constraintNode.get("score").asText());
            ArrayList<MatchAnalysis> matchScoreList = new ArrayList<MatchAnalysis>();
            JsonNode matchesNode = constraintNode.get("matches");
            JsonNode matchCountNode = constraintNode.get("matchCount");
            if (matchesNode == null) {
                constraintAnalysisList.put(constraintRef, new ConstraintAnalysis(constraintRef, constraintWeight, constraintScore, null, matchCountNode == null ? -1 : Integer.parseInt(matchCountNode.asText())));
                continue;
            }
            for (JsonNode matchNode : constraintNode.get("matches")) {
                Object parsedJustification;
                Score_ matchScore = this.parseScore(matchNode.get("score").asText());
                JsonNode justificationNode = matchNode.get("justification");
                if (justificationNode == null) {
                    throw new IllegalStateException("The match justification of constraint (%s)'s match is missing.".formatted(constraintRef));
                }
                String justificationString = justificationNode.toString();
                if (this.getConstraintJustificationClass(constraintRef) == null) {
                    parsedJustification = this.parseConstraintJustification(constraintRef, justificationString, matchScore);
                    matchScoreList.add(new MatchAnalysis(constraintRef, matchScore, parsedJustification));
                    continue;
                }
                parsedJustification = (ConstraintJustification)ctxt.readTreeAsValue(justificationNode, this.getConstraintJustificationClass(constraintRef));
                matchScoreList.add(new MatchAnalysis(constraintRef, matchScore, parsedJustification));
            }
            constraintAnalysisList.put(constraintRef, new ConstraintAnalysis(constraintRef, constraintWeight, constraintScore, matchScoreList));
        }
        return new ScoreAnalysis(score, constraintAnalysisList);
    }

    protected abstract Score_ parseScore(String var1);

    protected <ConstraintJustification_ extends ConstraintJustification> Class<ConstraintJustification_> getConstraintJustificationClass(ConstraintRef constraintRef) {
        return null;
    }

    protected <ConstraintJustification_ extends ConstraintJustification> ConstraintJustification_ parseConstraintJustification(ConstraintRef constraintRef, String constraintJustificationString, Score_ score) {
        throw new UnsupportedOperationException();
    }
}

