/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.BendableLongScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.WeightedScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.util.Arrays;
import java.util.Map;

public final class BendableLongScoreInliner
extends AbstractScoreInliner<BendableLongScore> {
    final long[] hardScores;
    final long[] softScores;

    BendableLongScoreInliner(Map<Constraint, BendableLongScore> constraintWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintWeightMap, constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter<BendableLongScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        Integer singleLevel = null;
        BendableLongScore constraintWeight = (BendableLongScore)this.constraintWeightMap.get(constraint);
        for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
            if (constraintWeight.hardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.hardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.hardLevelsSize();
            BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.hardOrSoftScore(singleLevel.intValue()));
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeHardScoreBy(impact, constraintMatchSupplier));
            }
            return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeSoftScoreBy(impact, constraintMatchSupplier));
        }
        BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length);
        return WeightedScoreImpacter.of(context, (ctx, impact, constraintMatchSupplier) -> ctx.changeScoreBy(impact, constraintMatchSupplier));
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized((int)initScore, (long[])Arrays.copyOf(this.hardScores, this.hardScores.length), (long[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

