/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic;

import ai.timefold.solver.benchmark.impl.report.ReportHelper;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.StatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.StatisticType;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import io.micrometer.core.instrument.Tags;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class SubSingleStatistic<Solution_, StatisticPoint_ extends StatisticPoint> {
    private static final String FAILED = "Failed";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @XmlTransient
    protected SubSingleBenchmarkResult subSingleBenchmarkResult;
    @XmlTransient
    protected List<StatisticPoint_> pointList;

    protected SubSingleStatistic() {
    }

    protected SubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public void setSubSingleBenchmarkResult(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
    }

    public abstract StatisticType getStatisticType();

    public List<StatisticPoint_> getPointList() {
        return this.pointList;
    }

    public void setPointList(List<StatisticPoint_> pointList) {
        this.pointList = pointList;
    }

    public String getRelativeCsvFilePath() {
        SingleBenchmarkResult singleBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult();
        return singleBenchmarkResult.getProblemBenchmarkResult().getProblemReportDirectoryName() + "/" + singleBenchmarkResult.getResultDirectoryName() + "/" + this.subSingleBenchmarkResult.getResultDirectoryName() + "/" + this.getCsvFileName();
    }

    public String getCsvFileName() {
        return this.getStatisticType().name() + ".csv";
    }

    public File getCsvFile() {
        return new File(this.subSingleBenchmarkResult.getResultDirectory(), this.getCsvFileName());
    }

    public abstract void open(StatisticRegistry<Solution_> var1, Tags var2);

    public void close(StatisticRegistry<Solution_> registry, Tags runTag) {
    }

    public void initPointList() {
        this.pointList = new ArrayList<StatisticPoint_>();
    }

    protected abstract String getCsvHeader();

    private void writeCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        try (BufferedWriter writer = Files.newBufferedWriter(csvFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.append(this.getCsvHeader());
            writer.newLine();
            for (StatisticPoint point : this.getPointList()) {
                writer.append(point.toCsvLine());
                writer.newLine();
            }
            if (this.subSingleBenchmarkResult.hasAnyFailure()) {
                writer.append(FAILED);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing csvFile (" + String.valueOf(csvFile) + ").", e);
        }
    }

    private void readCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        ScoreDefinition scoreDefinition = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSolverBenchmarkResult().getScoreDefinition();
        if (!this.pointList.isEmpty()) {
            throw new IllegalStateException("The pointList with size (" + this.pointList.size() + ") should be empty.");
        }
        if (!csvFile.exists()) {
            if (this.subSingleBenchmarkResult.hasAnyFailure()) {
                this.pointList = Collections.emptyList();
                return;
            }
            throw new IllegalStateException("The csvFile (" + String.valueOf(csvFile) + ") does not exist.");
        }
        try (BufferedReader reader = Files.newBufferedReader(csvFile.toPath(), StandardCharsets.UTF_8);){
            String line = reader.readLine();
            if (!this.getCsvHeader().equals(line)) {
                throw new IllegalStateException("The read line (" + line + ") is expected to be the header line (" + this.getCsvHeader() + ") for statisticType (" + String.valueOf(this.getStatisticType()) + ").");
            }
            line = reader.readLine();
            while (line != null && !line.isEmpty()) {
                if (line.equals(FAILED)) {
                    if (!this.subSingleBenchmarkResult.hasAnyFailure()) {
                        throw new IllegalStateException("SubSingleStatistic (" + String.valueOf(this) + ") failed even though the corresponding subSingleBenchmarkResult (" + String.valueOf(this.subSingleBenchmarkResult) + ") is a success.");
                    }
                } else {
                    List<String> csvLine = StatisticPoint.parseCsvLine(line).stream().map(String::intern).collect(Collectors.toList());
                    this.pointList.add(this.createPointFromCsvLine(scoreDefinition, csvLine));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed reading csvFile (" + String.valueOf(csvFile) + ").", e);
        }
    }

    public void unhibernatePointList() {
        if (!this.getCsvFile().exists()) {
            throw new IllegalStateException("The csvFile (" + String.valueOf(this.getCsvFile()) + ") of the statistic (" + String.valueOf(this.getStatisticType()) + ") of the single benchmark (" + String.valueOf(this.subSingleBenchmarkResult) + ") doesn't exist.");
        }
        if (this.pointList != null) {
            throw new IllegalStateException("The pointList (" + String.valueOf(this.pointList) + ") of the statistic (" + String.valueOf(this.getStatisticType()) + ") of the single benchmark (" + String.valueOf(this.subSingleBenchmarkResult) + ") should be null when unhibernating.");
        }
        this.initPointList();
        this.readCsvStatisticFile();
    }

    public void hibernatePointList() {
        this.writeCsvStatisticFile();
        this.pointList = null;
    }

    protected abstract StatisticPoint_ createPointFromCsvLine(ScoreDefinition<?> var1, List<String> var2);

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.subSingleBenchmarkResult.getName() + "_" + this.getStatisticType().name());
    }
}

