/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.config;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.config.statistic.SingleStatisticType;
import ai.timefold.solver.core.config.AbstractConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.persistence.common.api.domain.solution.SolutionFileIO;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"solutionFileIOClass", "writeOutputSolutionEnabled", "inputSolutionFileList", "problemStatisticEnabled", "problemStatisticTypeList", "singleStatisticTypeList"})
public class ProblemBenchmarksConfig
extends AbstractConfig<ProblemBenchmarksConfig> {
    private Class<? extends SolutionFileIO<?>> solutionFileIOClass = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XmlElement(name="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    private Boolean problemStatisticEnabled = null;
    @XmlElement(name="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;
    @XmlElement(name="singleStatisticType")
    private List<SingleStatisticType> singleStatisticTypeList = null;

    public @Nullable Class<? extends SolutionFileIO<?>> getSolutionFileIOClass() {
        return this.solutionFileIOClass;
    }

    public void setSolutionFileIOClass(@Nullable Class<? extends SolutionFileIO<?>> solutionFileIOClass) {
        this.solutionFileIOClass = solutionFileIOClass;
    }

    public @Nullable Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(@Nullable Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public @Nullable List<@NonNull File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(@Nullable List<@NonNull File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public @Nullable Boolean getProblemStatisticEnabled() {
        return this.problemStatisticEnabled;
    }

    public void setProblemStatisticEnabled(@Nullable Boolean problemStatisticEnabled) {
        this.problemStatisticEnabled = problemStatisticEnabled;
    }

    public @Nullable List<@NonNull ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(@Nullable List<@NonNull ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public @Nullable List<@NonNull SingleStatisticType> getSingleStatisticTypeList() {
        return this.singleStatisticTypeList;
    }

    public void setSingleStatisticTypeList(@Nullable List<@NonNull SingleStatisticType> singleStatisticTypeList) {
        this.singleStatisticTypeList = singleStatisticTypeList;
    }

    public @NonNull ProblemBenchmarksConfig withSolutionFileIOClass(@NonNull Class<? extends SolutionFileIO<?>> solutionFileIOClass) {
        this.setSolutionFileIOClass(solutionFileIOClass);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withWriteOutputSolutionEnabled(@NonNull Boolean writeOutputSolutionEnabled) {
        this.setWriteOutputSolutionEnabled(writeOutputSolutionEnabled);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withInputSolutionFileList(@NonNull List<@NonNull File> inputSolutionFileList) {
        this.setInputSolutionFileList(inputSolutionFileList);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withInputSolutionFiles(File ... inputSolutionFiles) {
        this.setInputSolutionFileList(List.of(inputSolutionFiles));
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withProblemStatisticsEnabled(@NonNull Boolean problemStatisticEnabled) {
        this.setProblemStatisticEnabled(problemStatisticEnabled);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withProblemStatisticTypeList(@NonNull List<@NonNull ProblemStatisticType> problemStatisticTypeList) {
        this.setProblemStatisticTypeList(problemStatisticTypeList);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withProblemStatisticTypes(ProblemStatisticType ... problemStatisticTypes) {
        this.setProblemStatisticTypeList(List.of(problemStatisticTypes));
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withSingleStatisticTypeList(@NonNull List<@NonNull SingleStatisticType> singleStatisticTypeList) {
        this.setSingleStatisticTypeList(singleStatisticTypeList);
        return this;
    }

    public @NonNull ProblemBenchmarksConfig withSingleStatisticTypes(SingleStatisticType ... singleStatisticTypes) {
        this.setSingleStatisticTypeList(List.of(singleStatisticTypes));
        return this;
    }

    public @NonNull List<@NonNull ProblemStatisticType> determineProblemStatisticTypeList() {
        if (this.problemStatisticEnabled != null && !this.problemStatisticEnabled.booleanValue()) {
            return Collections.emptyList();
        }
        if (this.problemStatisticTypeList == null || this.problemStatisticTypeList.isEmpty()) {
            return ProblemStatisticType.defaultList();
        }
        return this.problemStatisticTypeList;
    }

    public @NonNull List<@NonNull SingleStatisticType> determineSingleStatisticTypeList() {
        return Objects.requireNonNullElse(this.singleStatisticTypeList, Collections.emptyList());
    }

    public @NonNull ProblemBenchmarksConfig inherit(@NonNull ProblemBenchmarksConfig inheritedConfig) {
        this.solutionFileIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solutionFileIOClass, inheritedConfig.getSolutionFileIOClass());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.problemStatisticEnabled, (Object)inheritedConfig.getProblemStatisticEnabled());
        this.problemStatisticTypeList = ConfigUtils.inheritUniqueMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
        this.singleStatisticTypeList = ConfigUtils.inheritUniqueMergeableListProperty(this.singleStatisticTypeList, inheritedConfig.getSingleStatisticTypeList());
        return this;
    }

    public @NonNull ProblemBenchmarksConfig copyConfig() {
        return new ProblemBenchmarksConfig().inherit(this);
    }

    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.solutionFileIOClass);
    }
}

