/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.common;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.common.LongStatisticPoint;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public abstract class AbstractCalculationSpeedSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, LongStatisticPoint> {
    private final SolverMetric solverMetric;
    private final long timeMillisThresholdInterval;

    protected AbstractCalculationSpeedSubSingleStatistic(SolverMetric solverMetric, ProblemStatisticType statisticType, SubSingleBenchmarkResult benchmarkResult, long timeMillisThresholdInterval) {
        super(benchmarkResult, statisticType);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.solverMetric = solverMetric;
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
    }

    @Override
    public void open(final StatisticRegistry<Solution_> registry, final Tags runTag) {
        registry.addListener(this.solverMetric, new Consumer<Long>(){
            long nextTimeMillisThreshold;
            long lastTimeMillisSpent;
            final AtomicLong lastCalculationCount;
            {
                this.nextTimeMillisThreshold = AbstractCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
                this.lastTimeMillisSpent = 0L;
                this.lastCalculationCount = new AtomicLong(0L);
            }

            @Override
            public void accept(Long timeMillisSpent) {
                if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                    Double countNumber = SolverMetricUtil.getGaugeValue((MeterRegistry)registry, (SolverMetric)AbstractCalculationSpeedSubSingleStatistic.this.solverMetric, (Tags)runTag);
                    if (countNumber != null) {
                        long moveEvaluationCount = countNumber.longValue();
                        long countInterval = moveEvaluationCount - this.lastCalculationCount.get();
                        long timeMillisSpentInterval = timeMillisSpent - this.lastTimeMillisSpent;
                        if (timeMillisSpentInterval == 0L) {
                            timeMillisSpentInterval = 1L;
                        }
                        long speed = countInterval * 1000L / timeMillisSpentInterval;
                        AbstractCalculationSpeedSubSingleStatistic.this.pointList.add(new LongStatisticPoint(timeMillisSpent, speed));
                        this.lastCalculationCount.set(moveEvaluationCount);
                    }
                    this.lastTimeMillisSpent = timeMillisSpent;
                    this.nextTimeMillisThreshold += AbstractCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
                    if (this.nextTimeMillisThreshold < timeMillisSpent) {
                        this.nextTimeMillisThreshold = timeMillisSpent;
                    }
                }
            }
        });
    }

    @Override
    protected LongStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new LongStatisticPoint(Long.parseLong(csvLine.get(0)), Long.parseLong(csvLine.get(1)));
    }
}

