/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.movecountperstep;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.movecountperstep.MoveCountPerStepStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.movecountperstep.MoveCountPerStepSubSingleStatistic;
import java.util.Collections;
import java.util.List;

public class MoveCountPerStepProblemStatistic
extends ProblemStatistic<LineChart<Long, Long>> {
    private MoveCountPerStepProblemStatistic() {
    }

    public MoveCountPerStepProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.MOVE_COUNT_PER_STEP);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new MoveCountPerStepSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    protected List<LineChart<Long, Long>> generateCharts(BenchmarkReport benchmarkReport) {
        LineChart.Builder<Long, Long> builder = new LineChart.Builder<Long, Long>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            String acceptedSeriesLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix() + " accepted";
            String selectedSeriesLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix() + " selected";
            if (singleBenchmarkResult.hasAllSuccess()) {
                SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
                List list = subSingleStatistic.getPointList();
                for (MoveCountPerStepStatisticPoint point : list) {
                    long timeMillisSpent = point.getTimeMillisSpent();
                    builder.add(acceptedSeriesLabel, timeMillisSpent, point.getAcceptedMoveCount());
                    builder.add(selectedSeriesLabel, timeMillisSpent, point.getSelectedMoveCount());
                }
            }
            if (!singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) continue;
            builder.markFavorite(acceptedSeriesLabel);
            builder.markFavorite(selectedSeriesLabel);
        }
        return Collections.singletonList(builder.build("moveCountPerStepProblemStatisticChart", this.problemBenchmarkResult.getName() + " move count per step statistic", "Time spent", "Moves per step", true, true, false));
    }
}

