/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.movecountperstep;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.StatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.movecountperstep.MoveCountPerStepStatisticPoint;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.List;

public class MoveCountPerStepSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, MoveCountPerStepStatisticPoint> {
    private MoveCountPerStepSubSingleStatistic() {
    }

    public MoveCountPerStepSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, ProblemStatisticType.MOVE_COUNT_PER_STEP);
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag) {
        registry.addListener(SolverMetric.MOVE_COUNT_PER_STEP, timeMillisSpent -> {
            Double selected;
            Double accepted = SolverMetricUtil.getGaugeValue((MeterRegistry)registry, (String)(SolverMetric.MOVE_COUNT_PER_STEP.getMeterId() + ".accepted"), (Tags)runTag);
            if (accepted != null && (selected = SolverMetricUtil.getGaugeValue((MeterRegistry)registry, (String)(SolverMetric.MOVE_COUNT_PER_STEP.getMeterId() + ".selected"), (Tags)runTag)) != null) {
                this.pointList.add(new MoveCountPerStepStatisticPoint((long)timeMillisSpent, accepted.longValue(), selected.longValue()));
            }
        });
    }

    @Override
    protected String getCsvHeader() {
        return StatisticPoint.buildCsvLine("timeMillisSpent", "acceptedMoveCount", "selectedMoveCount");
    }

    @Override
    protected MoveCountPerStepStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new MoveCountPerStepStatisticPoint(Long.parseLong(csvLine.get(0)), Long.parseLong(csvLine.get(1)), Long.parseLong(csvLine.get(2)));
    }
}

