/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic;

import ai.timefold.solver.benchmark.impl.result.BenchmarkResult;
import ai.timefold.solver.core.api.score.Score;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public class StatisticUtils {
    private StatisticUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static double[] determineStandardDeviationDoubles(List<? extends BenchmarkResult> benchmarkResultList, Score averageScore, int successCount) {
        void var5_7;
        if (successCount <= 0) {
            return new double[0];
        }
        if (averageScore == null) {
            throw new IllegalArgumentException("Average score (" + String.valueOf(averageScore) + ") cannot be null.");
        }
        double[] differenceSquaredTotalDoubles = null;
        for (BenchmarkResult benchmarkResult : benchmarkResultList) {
            if (!benchmarkResult.hasAllSuccess()) continue;
            Score difference = benchmarkResult.getAverageScore().subtract(averageScore);
            double[] differenceDoubles = difference.toLevelDoubles();
            if (differenceSquaredTotalDoubles == null) {
                differenceSquaredTotalDoubles = new double[differenceDoubles.length];
            }
            for (int i = 0; i < differenceDoubles.length; ++i) {
                int n = i;
                differenceSquaredTotalDoubles[n] = differenceSquaredTotalDoubles[n] + Math.pow(differenceDoubles[i], 2.0);
            }
        }
        if (differenceSquaredTotalDoubles == null) {
            return new double[0];
        }
        double[] standardDeviationDoubles = new double[differenceSquaredTotalDoubles.length];
        boolean bl = false;
        while (var5_7 < differenceSquaredTotalDoubles.length) {
            standardDeviationDoubles[var5_7] = Math.pow((double)(differenceSquaredTotalDoubles[var5_7] / (double)successCount), 0.5);
            ++var5_7;
        }
        return standardDeviationDoubles;
    }

    public static String getStandardDeviationString(double[] standardDeviationDoubles) {
        if (standardDeviationDoubles == null) {
            return null;
        }
        StringBuilder standardDeviationString = new StringBuilder(standardDeviationDoubles.length * 9);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat exponentialFormat = new DecimalFormat("0.0#E0", decimalFormatSymbols);
        DecimalFormat decimalFormat = new DecimalFormat("0.0#", decimalFormatSymbols);
        boolean first = true;
        for (double standardDeviationDouble : standardDeviationDoubles) {
            if (first) {
                first = false;
            } else {
                standardDeviationString.append("/");
            }
            String abbreviated = 0.001 <= standardDeviationDouble && standardDeviationDouble <= 1.0E7 ? decimalFormat.format(standardDeviationDouble) : exponentialFormat.format(standardDeviationDouble);
            standardDeviationString.append(abbreviated);
        }
        return standardDeviationString.toString();
    }
}

