/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.xsd;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XsdAggregator {
    private static final String TNS_PREFIX = "tns";

    public static void main(String[] args) {
        if (args.length != 3) {
            String msg = "The XSD Aggregator expects 3 arguments:\n1) a path to the solver XSD file. \n2) a path to the benchmark XSD file. \n3) a path to an output file where the merged benchmark XSD should be saved to.";
            throw new IllegalArgumentException(msg);
        }
        File solverXsd = XsdAggregator.checkFileExists(new File(args[0]));
        File benchmarkXsd = XsdAggregator.checkFileExists(new File(args[1]));
        File outputXsd = new File(args[2]);
        if (!outputXsd.getParentFile().exists()) {
            outputXsd.getParentFile().mkdirs();
        }
        new XsdAggregator().mergeXmlSchemas(solverXsd, benchmarkXsd, outputXsd);
    }

    private static File checkFileExists(File file) {
        Objects.requireNonNull(file);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The file (%s) does not exist.", file.getAbsolutePath()));
        }
        return file;
    }

    private void mergeXmlSchemas(File solverSchemaFile, File benchmarkSchemaFile, File outputSchemaFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document solverSchema = this.parseXml(solverSchemaFile, factory);
        Element solverRootElement = solverSchema.getDocumentElement();
        Document benchmarkSchema = this.parseXml(benchmarkSchemaFile, factory);
        this.removeReferencesToSolverConfig(benchmarkSchema, benchmarkSchemaFile);
        this.copySolverConfigTypes(benchmarkSchema, solverRootElement);
        Transformer transformer = this.createTransformer();
        DOMSource source = new DOMSource(benchmarkSchema);
        StreamResult result = new StreamResult(outputSchemaFile);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Failed to write the resulting XSD to a file (" + outputSchemaFile.getAbsolutePath() + ").", e);
        }
    }

    private Document parseXml(File xmlFile, DocumentBuilderFactory documentBuilderFactory) {
        DocumentBuilder builder;
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Failed to create a " + DocumentBuilder.class.getName() + "instance.", e);
        }
        try {
            return builder.parse(xmlFile);
        }
        catch (SAXException saxException) {
            throw new IllegalArgumentException("Failed to parse an XML file (" + xmlFile.getAbsolutePath() + ").", saxException);
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Failed to open an XML file (" + xmlFile.getAbsolutePath() + ").", ioException);
        }
    }

    private void removeReferencesToSolverConfig(Document benchmarkSchema, File benchmarkSchemaFile) {
        boolean solverNamespaceRemoved = false;
        boolean solverElementRefRemoved = false;
        boolean importRemoved = false;
        NodeList nodeList = benchmarkSchema.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Element element = (Element)node;
            if ("xs:schema".equals(node.getNodeName())) {
                element.removeAttribute("xmlns:solver");
                solverNamespaceRemoved = true;
            }
            if (this.isXsElement(node) && this.hasAttribute(node, "ref", "solver:solver")) {
                element.removeAttribute("ref");
                element.setAttribute("name", "solver");
                element.setAttribute("type", "tns:solverConfig");
                solverElementRefRemoved = true;
            }
            if ("xs:import".equals(node.getNodeName())) {
                node.getParentNode().removeChild(node);
                importRemoved = true;
            }
            this.updateNodeAttributes(node, attr -> attr.getValue() != null && attr.getValue().startsWith("solver:"), oldValue -> oldValue.replace("solver:", "tns:"));
        }
        if (!solverElementRefRemoved) {
            String msg = String.format("An expected reference to the solver element was not found. Check the content of (%s).", benchmarkSchemaFile);
            throw new AssertionError((Object)msg);
        }
        if (!solverNamespaceRemoved) {
            String msg = String.format("An expected namespace (%s) declaration was not found. Check the content of (%s).", "https://timefold.ai/xsd/solver", benchmarkSchemaFile);
            throw new AssertionError((Object)msg);
        }
        if (!importRemoved) {
            String msg = String.format("An expected import element was not found. Check the content of (%s).", benchmarkSchemaFile);
            throw new AssertionError((Object)msg);
        }
    }

    private void copySolverConfigTypes(Document benchmarkSchema, Element solverSchemaRoot) {
        Element benchmarkSchemaRoot = benchmarkSchema.getDocumentElement();
        NodeList solverChildNodes = solverSchemaRoot.getChildNodes();
        for (int i = 0; i < solverChildNodes.getLength(); ++i) {
            boolean isSolverElementDeclaration;
            Node node = solverChildNodes.item(i);
            boolean bl = isSolverElementDeclaration = this.isXsElement(node) && this.hasAttribute(node, "name", "solver");
            if (isSolverElementDeclaration) continue;
            benchmarkSchemaRoot.appendChild(benchmarkSchema.importNode(node, true));
        }
    }

    private boolean isXsElement(Node node) {
        return "xs:element".equals(node.getNodeName());
    }

    private boolean hasAttribute(Node node, String attributeName, String attributeValue) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(attributeName);
        Objects.requireNonNull(attributeValue);
        Attr attribute = ((Element)node).getAttributeNode(attributeName);
        return attribute != null && attributeValue.equals(attribute.getValue());
    }

    private void updateNodeAttributes(Node node, Predicate<Attr> attributePredicate, UnaryOperator<String> valueFunction) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(attributePredicate);
        Objects.requireNonNull(valueFunction);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Attr attribute = (Attr)node.getAttributes().item(i);
            if (!attributePredicate.test(attribute)) continue;
            attribute.setValue((String)valueFunction.apply(attribute.getValue()));
        }
    }

    private Transformer createTransformer() {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException("Failed to create a " + Transformer.class.getName() + ".", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

