/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.result;

import ai.timefold.solver.core.api.score.Score;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;

public record ScoreDifferencePercentage(double[] percentageLevels) {
    public static <Score_ extends Score<Score_>> ScoreDifferencePercentage calculateScoreDifferencePercentage(Score_ baseScore, Score_ valueScore) {
        double[] valueLevels;
        double[] baseLevels = baseScore.toLevelDoubles();
        if (baseLevels.length != (valueLevels = valueScore.toLevelDoubles()).length) {
            throw new IllegalStateException("The baseScore (" + String.valueOf(baseScore) + ")'s levelsLength (" + baseLevels.length + ") is different from the valueScore (" + String.valueOf(valueScore) + ")'s levelsLength (" + valueLevels.length + ").");
        }
        double[] percentageLevels = new double[baseLevels.length];
        for (int i = 0; i < baseLevels.length; ++i) {
            percentageLevels[i] = ScoreDifferencePercentage.calculateDifferencePercentage(baseLevels[i], valueLevels[i]);
        }
        return new ScoreDifferencePercentage(percentageLevels);
    }

    public static double calculateDifferencePercentage(double base, double value) {
        double difference = value - base;
        if (base < 0.0) {
            return difference / -base;
        }
        if (base == 0.0) {
            if (difference == 0.0) {
                return 0.0;
            }
            return difference / base;
        }
        return difference / base;
    }

    public ScoreDifferencePercentage add(ScoreDifferencePercentage addend) {
        if (this.percentageLevels.length != addend.percentageLevels().length) {
            throw new IllegalStateException("The addend (" + String.valueOf(addend) + ")'s levelsLength (" + addend.percentageLevels().length + ") is different from the base (" + String.valueOf(this) + ")'s levelsLength (" + this.percentageLevels.length + ").");
        }
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] + addend.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage subtract(ScoreDifferencePercentage subtrahend) {
        if (this.percentageLevels.length != subtrahend.percentageLevels().length) {
            throw new IllegalStateException("The subtrahend (" + String.valueOf(subtrahend) + ")'s levelsLength (" + subtrahend.percentageLevels().length + ") is different from the base (" + String.valueOf(this) + ")'s levelsLength (" + this.percentageLevels.length + ").");
        }
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] - subtrahend.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage multiply(double multiplicand) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] * multiplicand;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage divide(double divisor) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] / divisor;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoreDifferencePercentage that = (ScoreDifferencePercentage)o;
        return Arrays.equals(this.percentageLevels, that.percentageLevels);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.percentageLevels);
    }

    @Override
    public String toString() {
        return this.toString(Locale.US);
    }

    public String toString(Locale locale) {
        StringBuilder s = new StringBuilder(this.percentageLevels.length * 8);
        DecimalFormat decimalFormat = new DecimalFormat("0.00%", DecimalFormatSymbols.getInstance(locale));
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            if (i > 0) {
                s.append("/");
            }
            s.append(decimalFormat.format(this.percentageLevels[i]));
        }
        return s.toString();
    }
}

