/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl;

import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.ProblemBenchmarksConfig;
import ai.timefold.solver.benchmark.config.statistic.SingleStatisticType;
import ai.timefold.solver.benchmark.impl.loader.FileProblemProvider;
import ai.timefold.solver.benchmark.impl.loader.InstanceProblemProvider;
import ai.timefold.solver.benchmark.impl.loader.ProblemProvider;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.PureSubSingleStatistic;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.persistence.common.api.domain.solution.SolutionFileIO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProblemBenchmarksFactory {
    private final ProblemBenchmarksConfig config;

    public ProblemBenchmarksFactory(ProblemBenchmarksConfig config) {
        this.config = config;
    }

    public <Solution_> void buildProblemBenchmarkList(SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        PlannerBenchmarkResult plannerBenchmarkResult = solverBenchmarkResult.getPlannerBenchmarkResult();
        List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList();
        for (ProblemProvider<Solution_> problemProvider : this.buildProblemProviderList(solverBenchmarkResult, extraProblems)) {
            ProblemBenchmarkResult problemBenchmarkResult;
            ProblemBenchmarkResult newProblemBenchmarkResult = this.buildProblemBenchmark(plannerBenchmarkResult, problemProvider);
            int index = unifiedProblemBenchmarkResultList.indexOf(newProblemBenchmarkResult);
            if (index < 0) {
                problemBenchmarkResult = newProblemBenchmarkResult;
                unifiedProblemBenchmarkResultList.add(problemBenchmarkResult);
            } else {
                problemBenchmarkResult = unifiedProblemBenchmarkResultList.get(index);
            }
            this.buildSingleBenchmark(solverBenchmarkResult, problemBenchmarkResult);
        }
    }

    private <Solution_> List<ProblemProvider<Solution_>> buildProblemProviderList(SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        if (ConfigUtils.isEmptyCollection(this.config.getInputSolutionFileList()) && extraProblems.length == 0) {
            throw new IllegalArgumentException("The solverBenchmarkResult (" + solverBenchmarkResult.getName() + ") has no problems.\nMaybe configure at least 1 <inputSolutionFile> directly or indirectly by inheriting it.\nOr maybe pass at least one problem to " + PlannerBenchmarkFactory.class.getSimpleName() + ".buildPlannerBenchmark().");
        }
        ArrayList<ProblemProvider<Solution_>> problemProviderList = new ArrayList<ProblemProvider<Solution_>>(extraProblems.length + Objects.requireNonNullElse(this.config.getInputSolutionFileList(), Collections.emptyList()).size());
        DefaultSolverFactory defaultSolverFactory = new DefaultSolverFactory(solverBenchmarkResult.getSolverConfig());
        SolutionDescriptor solutionDescriptor = defaultSolverFactory.getSolutionDescriptor();
        int extraProblemIndex = 0;
        for (Solution_ extraProblem : extraProblems) {
            if (extraProblem == null) {
                throw new IllegalStateException("The benchmark problem (" + String.valueOf(extraProblem) + ") is null.");
            }
            String problemName = "Problem_" + extraProblemIndex;
            problemProviderList.add(new InstanceProblemProvider<Solution_>(problemName, solutionDescriptor, extraProblem));
            ++extraProblemIndex;
        }
        if (ConfigUtils.isEmptyCollection(this.config.getInputSolutionFileList())) {
            if (this.config.getSolutionFileIOClass() != null) {
                throw new IllegalArgumentException("Cannot use solutionFileIOClass (" + String.valueOf(this.config.getSolutionFileIOClass()) + ") with an empty inputSolutionFileList (" + String.valueOf(this.config.getInputSolutionFileList()) + ").");
            }
        } else {
            SolutionFileIO<Solution_> solutionFileIO = this.buildSolutionFileIO();
            for (File inputSolutionFile : this.config.getInputSolutionFileList()) {
                if (!inputSolutionFile.exists()) {
                    throw new IllegalArgumentException("The inputSolutionFile (" + String.valueOf(inputSolutionFile) + ") does not exist.");
                }
                problemProviderList.add(new FileProblemProvider<Solution_>(solutionFileIO, inputSolutionFile));
            }
        }
        return problemProviderList;
    }

    private <Solution_> SolutionFileIO<Solution_> buildSolutionFileIO() {
        Class<? extends SolutionFileIO<?>> solutionFileIOClass = this.config.getSolutionFileIOClass();
        if (solutionFileIOClass == null) {
            throw new IllegalArgumentException("The solutionFileIOClass cannot be null.");
        }
        return (SolutionFileIO)ConfigUtils.newInstance((Object)((Object)this.config), (String)"solutionFileIOClass", solutionFileIOClass);
    }

    private <Solution_> ProblemBenchmarkResult<Solution_> buildProblemBenchmark(PlannerBenchmarkResult plannerBenchmarkResult, ProblemProvider<Solution_> problemProvider) {
        ProblemBenchmarkResult<Solution_> problemBenchmarkResult = new ProblemBenchmarkResult<Solution_>(plannerBenchmarkResult);
        problemBenchmarkResult.setName(problemProvider.getProblemName());
        problemBenchmarkResult.setProblemProvider(problemProvider);
        problemBenchmarkResult.setWriteOutputSolutionEnabled(Objects.requireNonNullElse(this.config.getWriteOutputSolutionEnabled(), false));
        List<ProblemStatistic> problemStatisticList = this.getProblemStatisticList(problemBenchmarkResult);
        problemBenchmarkResult.setProblemStatisticList(problemStatisticList);
        problemBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        return problemBenchmarkResult;
    }

    private List<ProblemStatistic> getProblemStatisticList(ProblemBenchmarkResult problemBenchmarkResult) {
        Boolean problemStatisticEnabled = this.config.getProblemStatisticEnabled();
        if (problemStatisticEnabled != null && !problemStatisticEnabled.booleanValue()) {
            if (!ConfigUtils.isEmptyCollection(this.config.getProblemStatisticTypeList())) {
                throw new IllegalArgumentException("The problemStatisticEnabled (%b) and problemStatisticTypeList (%s) cannot be used together.".formatted(problemStatisticEnabled, this.config.getProblemStatisticTypeList()));
            }
            return Collections.emptyList();
        }
        return this.config.determineProblemStatisticTypeList().stream().map(problemStatisticType -> problemStatisticType.buildProblemStatistic(problemBenchmarkResult)).toList();
    }

    private void buildSingleBenchmark(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        this.buildSubSingleBenchmarks(singleBenchmarkResult, solverBenchmarkResult.getSubSingleCount());
        List<SingleStatisticType> singleStatisticTypeList = this.config.determineSingleStatisticTypeList();
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
            subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(singleStatisticTypeList.size()));
        }
        for (SingleStatisticType singleStatisticType : singleStatisticTypeList) {
            for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                subSingleBenchmarkResult.getPureSubSingleStatisticList().add(singleStatisticType.buildPureSubSingleStatistic(subSingleBenchmarkResult));
            }
        }
        singleBenchmarkResult.initSubSingleStatisticMaps();
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
    }

    private void buildSubSingleBenchmarks(SingleBenchmarkResult parent, int subSingleCount) {
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(subSingleCount);
        for (int i = 0; i < subSingleCount; ++i) {
            SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(parent, i);
            subSingleBenchmarkResultList.add(subSingleBenchmarkResult);
        }
        parent.setSubSingleBenchmarkResultList(subSingleBenchmarkResultList);
    }
}

