/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.movecountpertype;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BarChart;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.movecountpertype.MoveCountPerTypeStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.movecountpertype.MoveCountPerTypeSubSingleStatistic;
import java.util.Collections;
import java.util.List;

public class MoveCountPerTypeProblemStatistic
extends ProblemStatistic<BarChart<Long>> {
    private MoveCountPerTypeProblemStatistic() {
    }

    public MoveCountPerTypeProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.MOVE_COUNT_PER_TYPE);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new MoveCountPerTypeSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    protected List<BarChart<Long>> generateCharts(BenchmarkReport benchmarkReport) {
        BarChart.Builder<Long> builder = new BarChart.Builder<Long>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            if (!singleBenchmarkResult.hasAllSuccess()) continue;
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
            List points = subSingleStatistic.getPointList();
            for (MoveCountPerTypeStatisticPoint point : points) {
                builder.add(solverLabel, point.getMoveType(), point.getCount());
            }
        }
        return Collections.singletonList(builder.build("moveCountPerTypeProblemStatisticChart", this.problemBenchmarkResult.getName() + " move count per type statistic", "Type", "Count", false));
    }
}

