/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.report;

import ai.timefold.solver.benchmark.impl.ranking.SolverRankingWeightFactory;
import ai.timefold.solver.benchmark.impl.report.BarChart;
import ai.timefold.solver.benchmark.impl.report.BoxPlot;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.report.MillisecondDurationNumberFormatFactory;
import ai.timefold.solver.benchmark.impl.report.ReportHelper;
import ai.timefold.solver.benchmark.impl.report.WebsiteResourceUtils;
import ai.timefold.solver.benchmark.impl.result.LoggingLevel;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.PureSubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkReport.class);
    public static final int CHARTED_SCORE_LEVEL_SIZE = 15;
    public static final int LOG_SCALE_MIN_DATASETS_COUNT = 5;
    private final PlannerBenchmarkResult plannerBenchmarkResult;
    private Locale locale = null;
    private ZoneId timezoneId = null;
    private Comparator<SolverBenchmarkResult> solverRankingComparator = null;
    private SolverRankingWeightFactory solverRankingWeightFactory = null;
    private List<BarChart<Double>> bestScoreSummaryChartList = null;
    private List<LineChart<Long, Double>> bestScoreScalabilitySummaryChartList = null;
    private List<BoxPlot> bestScoreDistributionSummaryChartList = null;
    private List<BarChart<Double>> winningScoreDifferenceSummaryChartList = null;
    private List<BarChart<Double>> worstScoreDifferencePercentageSummaryChartList = null;
    private LineChart<Long, Long> scoreCalculationSpeedSummaryChart;
    private LineChart<Long, Long> moveEvaluationSpeedSummaryChart;
    private BarChart<Double> worstScoreCalculationSpeedDifferencePercentageSummaryChart = null;
    private BarChart<Long> timeSpentSummaryChart = null;
    private LineChart<Long, Long> timeSpentScalabilitySummaryChart = null;
    private List<LineChart<Long, Double>> bestScorePerTimeSpentSummaryChartList = null;
    private Integer defaultShownScoreLevelIndex = null;
    private File htmlOverviewFile = null;

    public static Configuration createFreeMarkerConfiguration() {
        Configuration freeMarkerCfg = new Configuration(new Version(2, 3, 32));
        freeMarkerCfg.setDefaultEncoding("UTF-8");
        return freeMarkerCfg;
    }

    public BenchmarkReport(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ZoneId getTimezoneId() {
        return this.timezoneId;
    }

    public void setTimezoneId(ZoneId timezoneId) {
        this.timezoneId = timezoneId;
    }

    public Comparator<SolverBenchmarkResult> getSolverRankingComparator() {
        return this.solverRankingComparator;
    }

    public void setSolverRankingComparator(Comparator<SolverBenchmarkResult> solverRankingComparator) {
        this.solverRankingComparator = solverRankingComparator;
    }

    public SolverRankingWeightFactory getSolverRankingWeightFactory() {
        return this.solverRankingWeightFactory;
    }

    public void setSolverRankingWeightFactory(SolverRankingWeightFactory solverRankingWeightFactory) {
        this.solverRankingWeightFactory = solverRankingWeightFactory;
    }

    public List<BarChart<Double>> getBestScoreSummaryChartList() {
        return this.bestScoreSummaryChartList;
    }

    public List<LineChart<Long, Double>> getBestScoreScalabilitySummaryChartList() {
        return this.bestScoreScalabilitySummaryChartList;
    }

    public List<BoxPlot> getBestScoreDistributionSummaryChartList() {
        return this.bestScoreDistributionSummaryChartList;
    }

    public List<BarChart<Double>> getWinningScoreDifferenceSummaryChartList() {
        return this.winningScoreDifferenceSummaryChartList;
    }

    public List<BarChart<Double>> getWorstScoreDifferencePercentageSummaryChartList() {
        return this.worstScoreDifferencePercentageSummaryChartList;
    }

    public LineChart<Long, Long> getScoreCalculationSpeedSummaryChart() {
        return this.scoreCalculationSpeedSummaryChart;
    }

    public LineChart<Long, Long> getMoveEvaluationSpeedSummaryChart() {
        return this.moveEvaluationSpeedSummaryChart;
    }

    public BarChart<Double> getWorstScoreCalculationSpeedDifferencePercentageSummaryChart() {
        return this.worstScoreCalculationSpeedDifferencePercentageSummaryChart;
    }

    public BarChart<Long> getTimeSpentSummaryChart() {
        return this.timeSpentSummaryChart;
    }

    public LineChart<Long, Long> getTimeSpentScalabilitySummaryChart() {
        return this.timeSpentScalabilitySummaryChart;
    }

    public List<LineChart<Long, Double>> getBestScorePerTimeSpentSummaryChartList() {
        return this.bestScorePerTimeSpentSummaryChartList;
    }

    public Integer getDefaultShownScoreLevelIndex() {
        return this.defaultShownScoreLevelIndex;
    }

    public File getHtmlOverviewFile() {
        return this.htmlOverviewFile;
    }

    public String getSolverRankingClassSimpleName() {
        Class solverRankingClass = this.getSolverRankingClass();
        return solverRankingClass == null ? null : solverRankingClass.getSimpleName();
    }

    public String getSolverRankingClassFullName() {
        Class solverRankingClass = this.getSolverRankingClass();
        return solverRankingClass == null ? null : solverRankingClass.getName();
    }

    public void writeReport() {
        LOGGER.info("Generating benchmark report...");
        this.plannerBenchmarkResult.accumulateResults(this);
        this.bestScoreSummaryChartList = this.createBestScoreSummaryChart();
        this.bestScoreScalabilitySummaryChartList = this.createBestScoreScalabilitySummaryChart();
        this.winningScoreDifferenceSummaryChartList = this.createWinningScoreDifferenceSummaryChart();
        this.worstScoreDifferencePercentageSummaryChartList = this.createWorstScoreDifferencePercentageSummaryChart();
        this.bestScoreDistributionSummaryChartList = this.createBestScoreDistributionSummaryChart();
        this.scoreCalculationSpeedSummaryChart = this.createScoreCalculationSpeedSummaryChart();
        this.moveEvaluationSpeedSummaryChart = this.createMoveEvaluationSpeedSummaryChart();
        this.worstScoreCalculationSpeedDifferencePercentageSummaryChart = this.createWorstScoreCalculationSpeedDifferencePercentageSummaryChart();
        this.timeSpentSummaryChart = this.createTimeSpentSummaryChart();
        this.timeSpentScalabilitySummaryChart = this.createTimeSpentScalabilitySummaryChart();
        this.bestScorePerTimeSpentSummaryChartList = this.createBestScorePerTimeSpentSummaryChart();
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    if (!subSingleBenchmarkResult.hasAllSuccess()) continue;
                    for (SubSingleStatistic subSingleStatistic : subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
                        try {
                            subSingleStatistic.unhibernatePointList();
                        }
                        catch (IllegalStateException e) {
                            if (!this.plannerBenchmarkResult.getAggregation().booleanValue()) {
                                throw new IllegalStateException("Failed to unhibernate point list of SubSingleStatistic (" + String.valueOf(subSingleStatistic) + ") of SubSingleBenchmark (" + String.valueOf(subSingleBenchmarkResult) + ").", e);
                            }
                            LOGGER.trace("This is expected, aggregator doesn't copy CSV files. Could not read CSV file ({}) of sub single statistic ({}).", (Object)subSingleStatistic.getCsvFile().getAbsolutePath(), (Object)subSingleStatistic);
                        }
                    }
                }
            }
        }
        ArrayList<BarChart<Double>> chartsToWrite = new ArrayList<BarChart<Double>>(this.bestScoreSummaryChartList);
        chartsToWrite.addAll(this.bestScoreSummaryChartList);
        chartsToWrite.addAll(this.bestScoreScalabilitySummaryChartList);
        chartsToWrite.addAll(this.winningScoreDifferenceSummaryChartList);
        chartsToWrite.addAll(this.worstScoreDifferencePercentageSummaryChartList);
        chartsToWrite.addAll(this.bestScoreDistributionSummaryChartList);
        chartsToWrite.add((BarChart<Double>)((Object)this.scoreCalculationSpeedSummaryChart));
        chartsToWrite.add((BarChart<Double>)((Object)this.moveEvaluationSpeedSummaryChart));
        chartsToWrite.add(this.worstScoreCalculationSpeedDifferencePercentageSummaryChart);
        chartsToWrite.add(this.timeSpentSummaryChart);
        chartsToWrite.add((BarChart<Double>)((Object)this.timeSpentScalabilitySummaryChart));
        chartsToWrite.addAll(this.bestScorePerTimeSpentSummaryChartList);
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            if (!problemBenchmarkResult.hasAnySuccess()) continue;
            for (ProblemStatistic problemStatistic : problemBenchmarkResult.getProblemStatisticList()) {
                problemStatistic.createChartList(this);
                chartsToWrite.addAll(problemStatistic.getChartList());
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                for (PureSubSingleStatistic pureSubSingleStatistic : singleBenchmarkResult.getMedian().getPureSubSingleStatisticList()) {
                    pureSubSingleStatistic.createChartList(this);
                    chartsToWrite.addAll(pureSubSingleStatistic.getChartList());
                }
            }
        }
        chartsToWrite.parallelStream().forEach(c -> c.writeToFile(this.plannerBenchmarkResult.getBenchmarkReportDirectory().toPath().resolve("website/js")));
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    if (!subSingleBenchmarkResult.hasAllSuccess()) continue;
                    for (SubSingleStatistic subSingleStatistic : subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
                        if (this.plannerBenchmarkResult.getAggregation().booleanValue()) {
                            subSingleStatistic.setPointList(null);
                            continue;
                        }
                        subSingleStatistic.hibernatePointList();
                    }
                }
            }
        }
        this.determineDefaultShownScoreLevelIndex();
        this.writeHtmlOverviewFile();
    }

    public List<String> getWarningList() {
        LoggingLevel loggingLevelTimefoldCore;
        EnvironmentMode environmentMode;
        ArrayList<String> warningList = new ArrayList<String>();
        String javaVmName = System.getProperty("java.vm.name");
        if (javaVmName != null && javaVmName.contains("Client VM")) {
            warningList.add("The Java VM (" + javaVmName + ") is the Client VM. This decreases performance. Maybe start the java process with the argument \"-server\" to get better results.");
        }
        Integer parallelBenchmarkCount = this.plannerBenchmarkResult.getParallelBenchmarkCount();
        Integer availableProcessors = this.plannerBenchmarkResult.getAvailableProcessors();
        if (parallelBenchmarkCount != null && availableProcessors != null && parallelBenchmarkCount > availableProcessors) {
            warningList.add("The parallelBenchmarkCount (" + parallelBenchmarkCount + ") is higher than the number of availableProcessors (" + availableProcessors + "). This decreases performance. Maybe reduce the parallelBenchmarkCount.");
        }
        if ((environmentMode = this.plannerBenchmarkResult.getEnvironmentMode()) != null && environmentMode.isStepAssertOrMore()) {
            warningList.add("The environmentMode (%s) is step-asserting or more. This decreases performance. Maybe set the environmentMode to %s.".formatted(environmentMode, EnvironmentMode.PHASE_ASSERT));
        }
        if ((loggingLevelTimefoldCore = this.plannerBenchmarkResult.getLoggingLevelTimefoldSolverCore()) == LoggingLevel.TRACE) {
            warningList.add("The loggingLevel (" + String.valueOf((Object)loggingLevelTimefoldCore) + ") of ai.timefold.solver.core is high. This decreases performance. Maybe set the loggingLevel to " + String.valueOf((Object)LoggingLevel.DEBUG) + " or lower.");
        }
        return warningList;
    }

    private List<BarChart<Double>> createBestScoreSummaryChart() {
        ArrayList builderList = new ArrayList(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String problemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                double[] levelValues = singleBenchmarkResult.getAverageScore().toLevelDoubles();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new BarChart.Builder());
                    }
                    if (!Double.isFinite(levelValues[i])) continue;
                    BarChart.Builder builder = (BarChart.Builder)builderList.get(i);
                    builder.add(solverLabel, problemLabel, levelValues[i]);
                    if (!solverBenchmarkResult.isFavorite()) continue;
                    builder.markFavorite(solverLabel);
                }
            }
        }
        ArrayList<BarChart<Double>> chartList = new ArrayList<BarChart<Double>>(builderList.size());
        int scoreLevelIndex = 0;
        for (BarChart.Builder builder : builderList) {
            String scoreLevelLabel = this.plannerBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            BarChart chart = builder.build("bestScoreSummaryChart" + scoreLevelIndex, "Best " + scoreLevelLabel + " summary (higher is better)", "Data", "Best " + scoreLevelLabel, false);
            chartList.add(chart);
            ++scoreLevelIndex;
        }
        return chartList;
    }

    private List<LineChart<Long, Double>> createBestScoreScalabilitySummaryChart() {
        ArrayList builderList = new ArrayList(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                long problemScale = singleBenchmarkResult.getProblemBenchmarkResult().getProblemScale();
                double[] levelValues = singleBenchmarkResult.getAverageScore().toLevelDoubles();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new LineChart.Builder());
                    }
                    LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                    builder.add(solverLabel, problemScale, levelValues[i]);
                    if (!solverBenchmarkResult.isFavorite()) continue;
                    builder.markFavorite(solverLabel);
                }
            }
        }
        ArrayList<LineChart<Long, Double>> chartList = new ArrayList<LineChart<Long, Double>>(builderList.size());
        int scoreLevelIndex = 0;
        for (LineChart.Builder builder : builderList) {
            String scoreLevelLabel = this.plannerBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            chartList.add(builder.build("bestScoreScalabilitySummaryChart" + scoreLevelIndex, "Best " + scoreLevelLabel + " scalability summary (higher is better)", "Problem scale", "Best " + scoreLevelLabel, false, false, false));
            ++scoreLevelIndex;
        }
        return chartList;
    }

    private List<BoxPlot> createBestScoreDistributionSummaryChart() {
        ArrayList<BoxPlot.Builder> builderList = new ArrayList<BoxPlot.Builder>(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String problemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                ArrayList distributionLevelList = new ArrayList(15);
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    double[] levelValues = subSingleBenchmarkResult.getAverageScore().toLevelDoubles();
                    for (int i = 0; i < levelValues.length && i < 15; ++i) {
                        if (i >= distributionLevelList.size()) {
                            distributionLevelList.add(new ArrayList(singleBenchmarkResult.getSubSingleCount()));
                        }
                        ((List)distributionLevelList.get(i)).add(levelValues[i]);
                    }
                }
                for (int i = 0; i < distributionLevelList.size() && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new BoxPlot.Builder());
                    }
                    BoxPlot.Builder builder = (BoxPlot.Builder)builderList.get(i);
                    Iterator iterator = ((List)distributionLevelList.get(i)).iterator();
                    while (iterator.hasNext()) {
                        double y = (Double)iterator.next();
                        builder.add(solverLabel, problemLabel, y);
                    }
                    if (!solverBenchmarkResult.isFavorite()) continue;
                    builder.markFavorite(solverLabel);
                }
            }
        }
        ArrayList<BoxPlot> chartList = new ArrayList<BoxPlot>(builderList.size());
        int scoreLevelIndex = 0;
        for (BoxPlot.Builder builder : builderList) {
            String scoreLevelLabel = this.plannerBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            BoxPlot boxPlot = builder.build("bestScoreDistributionSummaryChart" + scoreLevelIndex, "Best " + scoreLevelLabel + " distribution summary (higher is better)", "Data", "Best " + scoreLevelLabel);
            chartList.add(boxPlot);
            ++scoreLevelIndex;
        }
        return chartList;
    }

    private List<BarChart<Double>> createWinningScoreDifferenceSummaryChart() {
        return this.createScoreDifferenceSummaryChart(singleBenchmarkResult -> singleBenchmarkResult.getWinningScoreDifference().toLevelDoubles(), scoreLevelIndex -> "winningScoreDifferenceSummaryChart" + scoreLevelIndex, scoreLevelLabel -> "Winning " + scoreLevelLabel + " difference summary (higher is better)", scoreLevelLabel -> "Winning " + scoreLevelLabel + " difference");
    }

    private List<BarChart<Double>> createWorstScoreDifferencePercentageSummaryChart() {
        return this.createScoreDifferenceSummaryChart(singleBenchmarkResult -> singleBenchmarkResult.getWorstScoreDifferencePercentage().percentageLevels(), scoreLevelIndex -> "worstScoreDifferencePercentageSummaryChart" + scoreLevelIndex, scoreLevelLabel -> "Worst " + scoreLevelLabel + " difference percentage summary (higher is better)", scoreLevelLabel -> "Worst " + scoreLevelLabel + " difference percentage");
    }

    private List<BarChart<Double>> createScoreDifferenceSummaryChart(Function<SingleBenchmarkResult, double[]> scoreLevelValueFunction, IntFunction<String> idFunction, Function<String, String> titleFunction, Function<String, String> yLabelFunction) {
        ArrayList builderList = new ArrayList(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String problemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                double[] levelValues = scoreLevelValueFunction.apply(singleBenchmarkResult);
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new BarChart.Builder());
                    }
                    if (!Double.isFinite(levelValues[i])) continue;
                    BarChart.Builder builder = (BarChart.Builder)builderList.get(i);
                    builder.add(solverLabel, problemLabel, levelValues[i] * 100.0);
                    if (!solverBenchmarkResult.isFavorite()) continue;
                    builder.markFavorite(solverLabel);
                }
            }
        }
        ArrayList<BarChart<Double>> chartList = new ArrayList<BarChart<Double>>(builderList.size());
        int scoreLevelIndex = 0;
        for (BarChart.Builder builder : builderList) {
            String scoreLevelLabel = this.plannerBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            BarChart chart = builder.build(idFunction.apply(scoreLevelIndex), titleFunction.apply(scoreLevelLabel), "Data", yLabelFunction.apply(scoreLevelLabel), false);
            chartList.add(chart);
            ++scoreLevelIndex;
        }
        return chartList;
    }

    private LineChart<Long, Long> createScoreCalculationSpeedSummaryChart() {
        return this.createScalabilitySummaryChart(SingleBenchmarkResult::getScoreCalculationSpeed, "scoreCalculationSpeedSummaryChart", "Score calculation speed summary (higher is better)", "Score calculation speed per second", false);
    }

    private LineChart<Long, Long> createMoveEvaluationSpeedSummaryChart() {
        return this.createScalabilitySummaryChart(SingleBenchmarkResult::getMoveEvaluationSpeed, "moveEvaluationSpeedSummaryChart", "Move evaluation speed summary (higher is better)", "Move evaluation speed per second", false);
    }

    private BarChart<Double> createWorstScoreCalculationSpeedDifferencePercentageSummaryChart() {
        return this.createSummaryBarChart(result -> result.getWorstScoreCalculationSpeedDifferencePercentage() * 100.0, "worstScoreCalculationSpeedDifferencePercentageSummaryChart", "Worst score calculation speed difference percentage summary (higher is better)", "Worst score calculation speed difference percentage", false);
    }

    private BarChart<Long> createTimeSpentSummaryChart() {
        return this.createSummaryBarChart(SingleBenchmarkResult::getTimeMillisSpent, "timeSpentSummaryChart", "Time spent summary (lower time is better)", "Time spent", true);
    }

    private <N extends Number> BarChart<N> createSummaryBarChart(Function<SingleBenchmarkResult, N> valueFunction, String id, String title, String yLabel, boolean timeOnY) {
        BarChart.Builder<Number> builder = new BarChart.Builder<Number>();
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                String problemLabel = singleBenchmarkResult.getProblemBenchmarkResult().getName();
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                builder.add(solverLabel, problemLabel, (Number)valueFunction.apply(singleBenchmarkResult));
                if (!solverBenchmarkResult.isFavorite()) continue;
                builder.markFavorite(solverLabel);
            }
        }
        return builder.build(id, title, "Data", yLabel, timeOnY);
    }

    private LineChart<Long, Long> createTimeSpentScalabilitySummaryChart() {
        return this.createScalabilitySummaryChart(SingleBenchmarkResult::getTimeMillisSpent, "timeSpentScalabilitySummaryChart", "Time spent scalability summary (lower is better)", "Time spent", true);
    }

    private LineChart<Long, Long> createScalabilitySummaryChart(ToLongFunction<SingleBenchmarkResult> valueFunction, String id, String title, String yLabel, boolean timeOnY) {
        LineChart.Builder builder = new LineChart.Builder();
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String solverLabel = solverBenchmarkResult.getNameWithFavoriteSuffix();
            if (solverBenchmarkResult.isFavorite()) {
                builder.markFavorite(solverLabel);
            }
            solverBenchmarkResult.getSingleBenchmarkResultList().stream().filter(SingleBenchmarkResult::hasAllSuccess).forEach(singleBenchmarkResult -> {
                long problemScale = singleBenchmarkResult.getProblemBenchmarkResult().getProblemScale();
                long timeMillisSpent = valueFunction.applyAsLong((SingleBenchmarkResult)singleBenchmarkResult);
                builder.add(solverLabel, problemScale, timeMillisSpent);
            });
        }
        return builder.build(id, title, "Problem scale", yLabel, false, false, timeOnY);
    }

    private List<LineChart<Long, Double>> createBestScorePerTimeSpentSummaryChart() {
        ArrayList builderList = new ArrayList(15);
        for (SolverBenchmarkResult solverBenchmarkResult : this.plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            String string = solverBenchmarkResult.getNameWithFavoriteSuffix();
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                long timeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                double[] levelValues = singleBenchmarkResult.getAverageScore().toLevelDoubles();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new LineChart.Builder());
                    }
                    LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                    builder.add(string, timeMillisSpent, levelValues[i]);
                    if (!solverBenchmarkResult.isFavorite()) continue;
                    builder.markFavorite(string);
                }
            }
        }
        this.bestScorePerTimeSpentSummaryChartList = new ArrayList<LineChart<Long, Double>>(builderList.size());
        int scoreLevelIndex = 0;
        for (LineChart.Builder builder : builderList) {
            String scoreLevelLabel = this.plannerBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            LineChart chart = builder.build("bestScorePerTimeSpentSummaryChart" + scoreLevelIndex, "Best " + scoreLevelLabel + " per time spent summary (higher left is better)", "Time spent", "Best " + scoreLevelLabel, false, true, false);
            this.bestScorePerTimeSpentSummaryChartList.add(chart);
            ++scoreLevelIndex;
        }
        return this.bestScorePerTimeSpentSummaryChartList;
    }

    private void determineDefaultShownScoreLevelIndex() {
        this.defaultShownScoreLevelIndex = Integer.MAX_VALUE;
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            if (!problemBenchmarkResult.hasAnySuccess()) continue;
            double[] winningScoreLevels = problemBenchmarkResult.getWinningSingleBenchmarkResult().getAverageScore().toLevelDoubles();
            int[] differenceCount = new int[winningScoreLevels.length];
            for (int i = 0; i < differenceCount.length; ++i) {
                differenceCount[i] = 0;
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                if (!singleBenchmarkResult.hasAllSuccess()) continue;
                double[] scoreLevels = singleBenchmarkResult.getAverageScore().toLevelDoubles();
                for (int i = 0; i < scoreLevels.length; ++i) {
                    if (scoreLevels[i] == winningScoreLevels[i]) continue;
                    differenceCount[i] = differenceCount[i] + 1;
                }
            }
            int firstInterestingLevel = differenceCount.length - 1;
            for (int i = 0; i < differenceCount.length; ++i) {
                if (differenceCount[i] <= 0) continue;
                firstInterestingLevel = i;
                break;
            }
            if (this.defaultShownScoreLevelIndex <= firstInterestingLevel) continue;
            this.defaultShownScoreLevelIndex = firstInterestingLevel;
        }
    }

    private void writeHtmlOverviewFile() {
        File benchmarkReportDirectory = this.plannerBenchmarkResult.getBenchmarkReportDirectory();
        WebsiteResourceUtils.copyResourcesTo(benchmarkReportDirectory);
        this.htmlOverviewFile = new File(benchmarkReportDirectory, "index.html");
        Configuration freemarkerCfg = BenchmarkReport.createFreeMarkerConfiguration();
        freemarkerCfg.setLocale(this.locale);
        freemarkerCfg.setClassForTemplateLoading(BenchmarkReport.class, "");
        freemarkerCfg.setCustomNumberFormats(Map.of("msDuration", MillisecondDurationNumberFormatFactory.INSTANCE));
        String templateFilename = "benchmarkReport.html.ftl";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("benchmarkReport", this);
        model.put("reportHelper", new ReportHelper());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOverviewFile), "UTF-8");){
            Template template = freemarkerCfg.getTemplate(templateFilename);
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write htmlOverviewFile (" + String.valueOf(this.htmlOverviewFile) + ").", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to htmlOverviewFile (" + String.valueOf(this.htmlOverviewFile) + ").", e);
        }
    }

    private Class getSolverRankingClass() {
        if (this.solverRankingComparator != null) {
            return this.solverRankingComparator.getClass();
        }
        if (this.solverRankingWeightFactory != null) {
            return this.solverRankingWeightFactory.getClass();
        }
        return null;
    }
}

