/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.cli;

import ai.timefold.solver.benchmark.api.PlannerBenchmark;
import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import java.io.File;

public class TimefoldBenchmarkCli {
    public static void main(String[] args) {
        File benchmarkConfigFile;
        if (args.length != 2) {
            System.err.println("Usage: TimefoldBenchmarkCli benchmarkConfigFile benchmarkDirectory");
            System.exit(1);
        }
        if (!(benchmarkConfigFile = new File(args[0])).exists()) {
            System.err.println("The benchmarkConfigFile (" + String.valueOf(benchmarkConfigFile) + ") does not exist.");
            System.exit(1);
        }
        File benchmarkDirectory = new File(args[1]);
        PlannerBenchmarkConfig benchmarkConfig = benchmarkConfigFile.getName().endsWith(".ftl") ? PlannerBenchmarkConfig.createFromFreemarkerXmlFile(benchmarkConfigFile) : PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile);
        benchmarkConfig.setBenchmarkDirectory(benchmarkDirectory);
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create(benchmarkConfig);
        PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark();
        benchmark.benchmark();
    }
}

