/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl;

import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubSingleBenchmarkRunner<Solution_>
implements Callable<SubSingleBenchmarkRunner<Solution_>> {
    public static final String NAME_MDC = "subSingleBenchmark.name";
    private static final Logger LOGGER = LoggerFactory.getLogger(SubSingleBenchmarkRunner.class);
    private final SubSingleBenchmarkResult subSingleBenchmarkResult;
    private final boolean warmUp;
    private Long randomSeed = null;
    private Throwable failureThrowable = null;

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult, boolean warmUp) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
        this.warmUp = warmUp;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    @Override
    public SubSingleBenchmarkRunner<Solution_> call() {
        MDC.put((String)NAME_MDC, (String)this.subSingleBenchmarkResult.getName());
        Runtime runtime = Runtime.getRuntime();
        SingleBenchmarkResult singleBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult();
        ProblemBenchmarkResult problemBenchmarkResult = singleBenchmarkResult.getProblemBenchmarkResult();
        Object problem = problemBenchmarkResult.readProblem();
        if (!problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.subSingleBenchmarkResult.setUsedMemoryAfterInputSolution(runtime.totalMemory() - runtime.freeMemory());
        }
        LOGGER.trace("Benchmark problem has been read for subSingleBenchmarkResult ({}).", (Object)this.subSingleBenchmarkResult);
        SolverConfig solverConfig = singleBenchmarkResult.getSolverBenchmarkResult().getSolverConfig();
        if (singleBenchmarkResult.getSubSingleCount() > 1) {
            solverConfig = new SolverConfig(solverConfig);
            solverConfig.offerRandomSeedFromSubSingleIndex((long)this.subSingleBenchmarkResult.getSubSingleBenchmarkIndex());
        }
        HashMap<String, String> subSingleBenchmarkTagMap = new HashMap<String, String>();
        String runId = UUID.randomUUID().toString();
        subSingleBenchmarkTagMap.put("timefold.benchmark.run", runId);
        solverConfig = new SolverConfig(solverConfig);
        this.randomSeed = solverConfig.getRandomSeed();
        DefaultSolverFactory solverFactory = new DefaultSolverFactory(new SolverConfig(solverConfig));
        StatisticRegistry statisticRegistry = new StatisticRegistry(solverFactory.getSolutionDescriptor().getScoreDefinition());
        Metrics.addRegistry(statisticRegistry);
        Tags runTag = Tags.of((String)"timefold.benchmark.run", (String)runId);
        this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().forEach((statisticType, subSingleStatistic) -> {
            subSingleStatistic.open(statisticRegistry, runTag);
            subSingleStatistic.initPointList();
        });
        DefaultSolver solver = (DefaultSolver)solverFactory.buildSolver();
        solver.setMonitorTagMap(subSingleBenchmarkTagMap);
        solver.addPhaseLifecycleListener(statisticRegistry);
        Object solution = solver.solve(problem);
        solver.removePhaseLifecycleListener(statisticRegistry);
        Metrics.removeRegistry(statisticRegistry);
        long timeMillisSpent = solver.getTimeMillisSpent();
        for (SubSingleStatistic subSingleStatistic2 : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic2.close(statisticRegistry, runTag);
            subSingleStatistic2.hibernatePointList();
        }
        if (!this.warmUp) {
            SolverScope solverScope = solver.getSolverScope();
            SolutionDescriptor solutionDescriptor = solverScope.getSolutionDescriptor();
            problemBenchmarkResult.registerProblemSizeStatistics(solverScope.getProblemSizeStatistics());
            this.subSingleBenchmarkResult.setScore(solutionDescriptor.getScore(solution), solverScope.isBestSolutionInitialized());
            this.subSingleBenchmarkResult.setTimeMillisSpent(timeMillisSpent);
            this.subSingleBenchmarkResult.setScoreCalculationCount(solverScope.getScoreCalculationCount());
            this.subSingleBenchmarkResult.setMoveEvaluationCount(solverScope.getMoveEvaluationCount());
            SolutionManager solutionManager = SolutionManager.create((SolverFactory)solverFactory);
            boolean isConstraintMatchEnabled = solver.getSolverScope().getScoreDirector().getConstraintMatchPolicy().isEnabled();
            if (isConstraintMatchEnabled) {
                ScoreExplanation scoreExplanation = solutionManager.explain(solution, SolutionUpdatePolicy.NO_UPDATE);
                this.subSingleBenchmarkResult.setScoreExplanationSummary(scoreExplanation.getSummary());
            }
            problemBenchmarkResult.writeSolution(this.subSingleBenchmarkResult, solution);
        }
        MDC.remove((String)NAME_MDC);
        return this;
    }

    public String getName() {
        return this.subSingleBenchmarkResult.getName();
    }

    public String toString() {
        return this.subSingleBenchmarkResult.toString();
    }
}

