/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.loader;

import ai.timefold.solver.benchmark.impl.loader.ProblemProvider;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.persistence.common.api.domain.solution.SolutionFileIO;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.util.Objects;

public class FileProblemProvider<Solution_>
implements ProblemProvider<Solution_> {
    @XmlTransient
    private SolutionFileIO<Solution_> solutionFileIO;
    private File problemFile;

    private FileProblemProvider() {
    }

    public FileProblemProvider(SolutionFileIO<Solution_> solutionFileIO, File problemFile) {
        this.solutionFileIO = solutionFileIO;
        this.problemFile = problemFile;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    @Override
    public String getProblemName() {
        String name = this.problemFile.getName();
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return name.substring(0, lastDotIndex);
        }
        return name;
    }

    @Override
    public Solution_ readProblem() {
        return (Solution_)this.solutionFileIO.read(this.problemFile);
    }

    @Override
    public void writeSolution(Solution_ solution, SubSingleBenchmarkResult subSingleBenchmarkResult) {
        String filename = subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().getName() + "." + this.solutionFileIO.getOutputFileExtension();
        File solutionFile = new File(subSingleBenchmarkResult.getResultDirectory(), filename);
        this.solutionFileIO.write(solution, solutionFile);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileProblemProvider that = (FileProblemProvider)other;
        return Objects.equals(this.problemFile, that.problemFile);
    }

    public int hashCode() {
        return Objects.hash(this.problemFile);
    }

    public String toString() {
        return this.problemFile.toString();
    }
}

