/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import java.util.Collections;
import java.util.Comparator;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class HandlerSorterAdapter
extends MethodNode {
    private final MethodVisitor mv;

    public HandlerSorterAdapter(MethodVisitor mv, int api, int access, String name, String desc, String signature, String[] exceptions) {
        super(api, access, name, desc, signature, exceptions);
        this.mv = mv;
    }

    public void visitEnd() {
        TryCatchBlockLengthComparator comp = new TryCatchBlockLengthComparator(this);
        Collections.sort(this.tryCatchBlocks, comp);
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    static class TryCatchBlockLengthComparator
    implements Comparator {
        private final MethodNode meth;

        public TryCatchBlockLengthComparator(MethodNode meth) {
            this.meth = meth;
        }

        public int compare(Object o1, Object o2) {
            int len1 = this.blockLength((TryCatchBlockNode)o1);
            int len2 = this.blockLength((TryCatchBlockNode)o2);
            return len1 - len2;
        }

        private int blockLength(TryCatchBlockNode block) {
            int startidx = this.meth.instructions.indexOf((AbstractInsnNode)block.start);
            int endidx = this.meth.instructions.indexOf((AbstractInsnNode)block.end);
            return endidx - startidx;
        }
    }
}

