/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CopyOnWriteMap<Key_, Value_>
implements Map<Key_, Value_> {
    private final Map<Key_, Value_> immutableMap;
    private Optional<Map<Key_, Value_>> modifiedMap;

    public CopyOnWriteMap(Map<Key_, Value_> immutableMap) {
        this.immutableMap = immutableMap;
        this.modifiedMap = Optional.empty();
    }

    @Override
    public int size() {
        return this.modifiedMap.map(Map::size).orElseGet(this.immutableMap::size);
    }

    @Override
    public boolean isEmpty() {
        return this.modifiedMap.map(Map::isEmpty).orElseGet(this.immutableMap::isEmpty);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.modifiedMap.map(map -> map.containsKey(o)).orElseGet(() -> this.immutableMap.containsKey(o));
    }

    @Override
    public boolean containsValue(Object o) {
        return this.modifiedMap.map(map -> map.containsValue(o)).orElseGet(() -> this.immutableMap.containsValue(o));
    }

    @Override
    public Value_ get(Object o) {
        return (Value_)this.modifiedMap.map(map -> map.get(o)).orElseGet(() -> this.immutableMap.get(o));
    }

    @Override
    public Set<Key_> keySet() {
        return this.modifiedMap.map(Map::keySet).orElseGet(this.immutableMap::keySet);
    }

    @Override
    public Collection<Value_> values() {
        return this.modifiedMap.map(Map::values).orElseGet(this.immutableMap::values);
    }

    @Override
    public Set<Map.Entry<Key_, Value_>> entrySet() {
        return this.modifiedMap.map(Map::entrySet).orElseGet(this.immutableMap::entrySet);
    }

    @Override
    public Value_ put(Key_ key, Value_ value) {
        if (this.modifiedMap.isEmpty()) {
            this.modifiedMap = Optional.of(new HashMap<Key_, Value_>(this.immutableMap));
        }
        return this.modifiedMap.get().put(key, value);
    }

    @Override
    public Value_ remove(Object o) {
        if (this.modifiedMap.isEmpty()) {
            this.modifiedMap = Optional.of(new HashMap<Key_, Value_>(this.immutableMap));
        }
        return this.modifiedMap.get().remove(o);
    }

    @Override
    public void putAll(Map<? extends Key_, ? extends Value_> map) {
        if (this.modifiedMap.isEmpty()) {
            this.modifiedMap = Optional.of(new HashMap<Key_, Value_>(this.immutableMap));
        }
        this.modifiedMap.get().putAll(map);
    }

    @Override
    public void clear() {
        if (this.modifiedMap.isEmpty()) {
            this.modifiedMap = Optional.of(new HashMap<Key_, Value_>(this.immutableMap));
        }
        this.modifiedMap.get().clear();
    }
}

