/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import ai.timefold.jpyinterpreter.opcodes.stack.CopyOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.DupOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.DupTwoOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.PopOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.RotateFourOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.RotateThreeOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.RotateTwoOpcode;
import ai.timefold.jpyinterpreter.opcodes.stack.SwapOpcode;
import java.util.function.Function;

public enum StackOpDescriptor implements OpcodeDescriptor
{
    POP_TOP(PopOpcode::new),
    ROT_TWO(RotateTwoOpcode::new),
    ROT_THREE(RotateThreeOpcode::new),
    ROT_FOUR(RotateFourOpcode::new),
    COPY(CopyOpcode::new),
    SWAP(SwapOpcode::new),
    DUP_TOP(DupOpcode::new),
    DUP_TOP_TWO(DupTwoOpcode::new);

    final VersionMapping versionLookup;

    private StackOpDescriptor(Function<PythonBytecodeInstruction, Opcode> opcodeFunction) {
        this.versionLookup = VersionMapping.constantMapping(opcodeFunction);
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

