/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import ai.timefold.jpyinterpreter.opcodes.meta.NopOpcode;
import ai.timefold.jpyinterpreter.opcodes.meta.UnaryIntrinsicFunction;
import java.util.function.Function;

public enum MetaOpDescriptor implements OpcodeDescriptor
{
    NOP(NopOpcode::new),
    CACHE(NopOpcode::new),
    PRECALL(NopOpcode::new),
    MAKE_CELL(NopOpcode::new),
    COPY_FREE_VARS(NopOpcode::new),
    CALL_INTRINSIC_1(UnaryIntrinsicFunction::lookup),
    EXTENDED_ARG(ignored -> {
        throw new UnsupportedOperationException("EXTENDED_ARG");
    }),
    LOAD_BUILD_CLASS(ignored -> {
        throw new UnsupportedOperationException("LOAD_BUILD_CLASS");
    }),
    SETUP_ANNOTATIONS(NopOpcode::new);

    private final VersionMapping versionLookup;

    private MetaOpDescriptor(Function<PythonBytecodeInstruction, Opcode> opcodeFunction) {
        this.versionLookup = VersionMapping.constantMapping(opcodeFunction);
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

