/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.PythonCell;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class VariableImplementor {
    public static void loadLocalVariable(MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        localVariableHelper.readLocal(methodVisitor, instruction.arg());
    }

    public static void storeInLocalVariable(MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        localVariableHelper.writeLocal(methodVisitor, instruction.arg());
    }

    public static void deleteGlobalVariable(MethodVisitor methodVisitor, String className, PythonCompiledFunction pythonCompiledFunction, PythonBytecodeInstruction instruction) {
        String globalName = pythonCompiledFunction.co_names.get(instruction.arg());
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitTypeInsn(192, className);
        methodVisitor.visitFieldInsn(180, className, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(178, className, "__globals__", Type.getDescriptor(Map.class));
        methodVisitor.visitLdcInsn((Object)globalName);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonInterpreter.class), "deleteGlobal", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class), Type.getType(String.class)}), true);
    }

    public static void loadGlobalVariable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int globalIndex, PythonLikeType globalType) {
        PythonCompiledFunction pythonCompiledFunction = functionMetadata.pythonCompiledFunction;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        String className = functionMetadata.className;
        String globalName = pythonCompiledFunction.co_names.get(globalIndex);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitTypeInsn(192, className);
        methodVisitor.visitFieldInsn(180, className, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(178, className, "__globals__", Type.getDescriptor(Map.class));
        methodVisitor.visitLdcInsn((Object)globalName);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonInterpreter.class), "getGlobal", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(Map.class), Type.getType(String.class)}), true);
        methodVisitor.visitTypeInsn(192, globalType.getJavaTypeInternalName());
    }

    public static void storeInGlobalVariable(MethodVisitor methodVisitor, String className, PythonCompiledFunction pythonCompiledFunction, PythonBytecodeInstruction instruction) {
        String globalName = pythonCompiledFunction.co_names.get(instruction.arg());
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitTypeInsn(192, className);
        methodVisitor.visitFieldInsn(180, className, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitFieldInsn(178, className, "__globals__", Type.getDescriptor(Map.class));
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitLdcInsn((Object)globalName);
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonInterpreter.class), "setGlobal", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class), Type.getType(String.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void deleteLocalVariable(MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        methodVisitor.visitInsn(1);
        localVariableHelper.writeLocal(methodVisitor, instruction.arg());
    }

    public static int getCellIndex(FunctionMetadata functionMetadata, int instructionArg) {
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
            if (instructionArg >= functionMetadata.pythonCompiledFunction.co_cellvars.size()) {
                return instructionArg - functionMetadata.pythonCompiledFunction.co_varnames.size();
            }
            return instructionArg;
        }
        return instructionArg;
    }

    public static void createCell(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, int cellIndex) {
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonCell.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonCell.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(89);
        localVariableHelper.readCellInitialValue(methodVisitor, cellIndex);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeObject.class));
        methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonCell.class), "cellValue", Type.getDescriptor(PythonLikeObject.class));
        localVariableHelper.writeCell(methodVisitor, cellIndex);
    }

    public static void setupFreeVariableCell(MethodVisitor methodVisitor, String internalClassName, LocalVariableHelper localVariableHelper, int cellIndex) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, "__closure__", Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitLdcInsn((Object)cellIndex);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Integer.TYPE)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonCell.class));
        localVariableHelper.writeFreeCell(methodVisitor, cellIndex);
    }

    public static void loadCell(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int cellIndex) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        localVariableHelper.readCell(methodVisitor, cellIndex);
    }

    public static void loadCellVariable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int cellIndex) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        VariableImplementor.loadCell(functionMetadata, stackMetadata, cellIndex);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonCell.class), "cellValue", Type.getDescriptor(PythonLikeObject.class));
    }

    public static void storeInCellVariable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int cellIndex) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        VariableImplementor.loadCell(functionMetadata, stackMetadata, cellIndex);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonCell.class), "cellValue", Type.getDescriptor(PythonLikeObject.class));
    }

    public static void deleteCellVariable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int cellIndex) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        VariableImplementor.loadCell(functionMetadata, stackMetadata, cellIndex);
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonCell.class), "cellValue", Type.getDescriptor(PythonLikeObject.class));
    }
}

