/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonDefaultArgumentImplementor;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.CollectionImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.BoundPythonLikeFunction;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class KnownCallImplementor {
    static void unwrapBoundMethod(PythonFunctionSignature pythonFunctionSignature, FunctionMetadata functionMetadata, StackMetadata stackMetadata, int posFromTOS) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        if (pythonFunctionSignature.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.VIRTUAL || pythonFunctionSignature.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.INTERFACE) {
            StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, posFromTOS);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
            methodVisitor.visitTypeInsn(192, pythonFunctionSignature.getMethodDescriptor().getDeclaringClassInternalName());
            StackManipulationImplementor.shiftTOSDownBy(functionMetadata, stackMetadata, posFromTOS);
        }
    }

    public static void callMethod(PythonFunctionSignature pythonFunctionSignature, MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, int argumentCount) {
        int i;
        int i2;
        if (pythonFunctionSignature.isClassMethod()) {
            ++argumentCount;
        }
        int specPositionalArgumentCount = pythonFunctionSignature.getArgumentSpec().getAllowPositionalArgumentCount();
        int missingValues = Math.max(0, specPositionalArgumentCount - argumentCount);
        int[] argumentLocals = new int[specPositionalArgumentCount];
        int capturedExtraPositionalArgumentsLocal = localVariableHelper.newLocal();
        for (i2 = 0; i2 < argumentLocals.length; ++i2) {
            argumentLocals[i2] = localVariableHelper.newLocal();
        }
        if (pythonFunctionSignature.getArgumentSpec().hasExtraPositionalArgumentsCapture()) {
            CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, Math.max(0, argumentCount - specPositionalArgumentCount));
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeTuple.class), capturedExtraPositionalArgumentsLocal);
        } else if (argumentCount > specPositionalArgumentCount) {
            throw new IllegalStateException("Too many positional arguments given for argument spec " + String.valueOf(pythonFunctionSignature.getArgumentSpec()));
        }
        for (i2 = specPositionalArgumentCount - missingValues - 1; i2 >= 0; --i2) {
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[i2]);
        }
        if (pythonFunctionSignature.isVirtualMethod()) {
            methodVisitor.visitTypeInsn(192, pythonFunctionSignature.getMethodDescriptor().getDeclaringClassInternalName());
        }
        if (pythonFunctionSignature.isClassMethod()) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[0]);
            methodVisitor.visitInsn(89);
            Label ifIsBoundFunction = new Label();
            Label doneGettingType = new Label();
            methodVisitor.visitTypeInsn(193, Type.getInternalName(BoundPythonLikeFunction.class));
            methodVisitor.visitJumpInsn(154, ifIsBoundFunction);
            methodVisitor.visitInsn(89);
            methodVisitor.visitTypeInsn(193, Type.getInternalName(PythonLikeType.class));
            methodVisitor.visitJumpInsn(154, doneGettingType);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
            methodVisitor.visitJumpInsn(167, doneGettingType);
            methodVisitor.visitLabel(ifIsBoundFunction);
            methodVisitor.visitTypeInsn(192, Type.getInternalName(BoundPythonLikeFunction.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
            methodVisitor.visitLabel(doneGettingType);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[0]);
        }
        for (int i3 = 0; i3 < Math.min(specPositionalArgumentCount, argumentCount); ++i3) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[i3]);
            methodVisitor.visitLdcInsn((Object)Type.getType((String)("L" + pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(i3) + ";")));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "coerceToType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(Class.class)}), false);
            if (i3 == 0 && pythonFunctionSignature.isClassMethod()) {
                methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeType.class));
                continue;
            }
            methodVisitor.visitTypeInsn(192, pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(i3));
        }
        int defaultOffset = pythonFunctionSignature.getArgumentSpec().getTotalArgumentCount() - pythonFunctionSignature.getDefaultArgumentList().size();
        for (i = specPositionalArgumentCount - missingValues; i < specPositionalArgumentCount; ++i) {
            if (pythonFunctionSignature.getArgumentSpec().isArgumentNullable(i)) {
                methodVisitor.visitInsn(1);
                continue;
            }
            methodVisitor.visitFieldInsn(178, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName(), PythonDefaultArgumentImplementor.getConstantName(i - defaultOffset), "L" + pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(i) + ";");
        }
        if (pythonFunctionSignature.getArgumentSpec().hasExtraPositionalArgumentsCapture()) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeTuple.class), capturedExtraPositionalArgumentsLocal);
        }
        if (pythonFunctionSignature.getArgumentSpec().hasExtraKeywordArgumentsCapture()) {
            CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
        }
        pythonFunctionSignature.getMethodDescriptor().callMethod(methodVisitor);
        for (i = 0; i < argumentLocals.length; ++i) {
            localVariableHelper.freeLocal();
        }
        localVariableHelper.freeLocal();
    }

    public static void callPython311andAbove(PythonFunctionSignature pythonFunctionSignature, FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount, List<String> keywordArgumentNameList) {
        int i;
        int argumentIndex;
        Object keywordArgument;
        int extraPositionalArgumentsLocal;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        int specTotalArgumentCount = pythonFunctionSignature.getArgumentSpec().getTotalArgumentCount();
        int positionalArgumentCount = argumentCount - keywordArgumentNameList.size();
        int[] argumentLocals = new int[specTotalArgumentCount];
        for (int i2 = 0; i2 < argumentLocals.length; ++i2) {
            argumentLocals[i2] = localVariableHelper.newLocal();
        }
        int extraKeywordArgumentsLocal = pythonFunctionSignature.getArgumentSpec().getExtraKeywordsArgumentIndex().isPresent() ? argumentLocals[pythonFunctionSignature.getArgumentSpec().getExtraKeywordsArgumentIndex().get()] : -1;
        int n = extraPositionalArgumentsLocal = pythonFunctionSignature.getArgumentSpec().getExtraPositionalsArgumentIndex().isPresent() ? argumentLocals[pythonFunctionSignature.getArgumentSpec().getExtraPositionalsArgumentIndex().get()] : -1;
        if (extraKeywordArgumentsLocal != -1) {
            CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeDict.class), extraKeywordArgumentsLocal);
        }
        int positionalArgumentStart = pythonFunctionSignature.isClassMethod() ? 1 : 0;
        for (int keywordArgumentNameIndex = keywordArgumentNameList.size() - 1; keywordArgumentNameIndex >= 0; --keywordArgumentNameIndex) {
            keywordArgument = keywordArgumentNameList.get(keywordArgumentNameIndex);
            argumentIndex = pythonFunctionSignature.getArgumentSpec().getArgumentIndex((String)keywordArgument);
            if (argumentIndex == -1) {
                localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeDict.class), extraKeywordArgumentsLocal);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeDict.class));
                methodVisitor.visitInsn(95);
                methodVisitor.visitLdcInsn(keywordArgument);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonString.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonString.class), (Type[])new Type[]{Type.getType(String.class)}), false);
                methodVisitor.visitInsn(95);
                methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeDict.class), "put", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class)}), false);
                continue;
            }
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[argumentIndex]);
        }
        if (extraPositionalArgumentsLocal != -1) {
            CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, Math.max(0, positionalArgumentCount - pythonFunctionSignature.getArgumentSpec().getAllowPositionalArgumentCount() + positionalArgumentStart));
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeTuple.class), extraPositionalArgumentsLocal);
        }
        for (int i3 = Math.min(positionalArgumentCount + positionalArgumentStart, pythonFunctionSignature.getArgumentSpec().getAllowPositionalArgumentCount()) - 1; i3 >= positionalArgumentStart; --i3) {
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[i3]);
        }
        int defaultOffset = pythonFunctionSignature.getArgumentSpec().getTotalArgumentCount() - pythonFunctionSignature.getDefaultArgumentList().size();
        keywordArgument = pythonFunctionSignature.getArgumentSpec().getUnspecifiedArgumentSet(positionalArgumentCount + positionalArgumentStart, keywordArgumentNameList).iterator();
        while (keywordArgument.hasNext()) {
            argumentIndex = (Integer)keywordArgument.next();
            if (pythonFunctionSignature.getArgumentSpec().isArgumentNullable(argumentIndex)) {
                methodVisitor.visitInsn(1);
            } else {
                methodVisitor.visitFieldInsn(178, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName(), PythonDefaultArgumentImplementor.getConstantName(argumentIndex - defaultOffset), "L" + pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(argumentIndex) + ";");
            }
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[argumentIndex]);
        }
        if (pythonFunctionSignature.isVirtualMethod()) {
            methodVisitor.visitTypeInsn(192, pythonFunctionSignature.getMethodDescriptor().getDeclaringClassInternalName());
        }
        if (pythonFunctionSignature.isClassMethod()) {
            methodVisitor.visitInsn(89);
            Label ifIsBoundFunction = new Label();
            Label doneGettingType = new Label();
            methodVisitor.visitTypeInsn(193, Type.getInternalName(BoundPythonLikeFunction.class));
            methodVisitor.visitJumpInsn(154, ifIsBoundFunction);
            methodVisitor.visitInsn(89);
            methodVisitor.visitTypeInsn(193, Type.getInternalName(PythonLikeType.class));
            methodVisitor.visitJumpInsn(154, doneGettingType);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
            methodVisitor.visitJumpInsn(167, doneGettingType);
            methodVisitor.visitLabel(ifIsBoundFunction);
            methodVisitor.visitTypeInsn(192, Type.getInternalName(BoundPythonLikeFunction.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
            methodVisitor.visitLabel(doneGettingType);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[0]);
        }
        for (i = 0; i < specTotalArgumentCount; ++i) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), argumentLocals[i]);
            methodVisitor.visitLdcInsn((Object)Type.getType((String)("L" + pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(i) + ";")));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "coerceToType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(Class.class)}), false);
            methodVisitor.visitTypeInsn(192, pythonFunctionSignature.getArgumentSpec().getArgumentTypeInternalName(i));
        }
        pythonFunctionSignature.getMethodDescriptor().callMethod(methodVisitor);
        if (!pythonFunctionSignature.isClassMethod()) {
            methodVisitor.visitInsn(95);
            methodVisitor.visitInsn(87);
        }
        if (stackMetadata.getTypeAtStackIndex(argumentCount + 1) == BuiltinTypes.NULL_TYPE) {
            methodVisitor.visitInsn(95);
            methodVisitor.visitInsn(87);
        }
        for (i = 0; i < argumentLocals.length; ++i) {
            localVariableHelper.freeLocal();
        }
    }

    public static void callWithoutKeywords(PythonFunctionSignature pythonFunctionSignature, FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        KnownCallImplementor.callWithKeywordsAndUnwrapSelf(pythonFunctionSignature, functionMetadata, stackMetadata, argumentCount);
    }

    public static void callWithKeywordsAndUnwrapSelf(PythonFunctionSignature pythonFunctionSignature, FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount) {
        KnownCallImplementor.callWithKeywords(pythonFunctionSignature, functionMetadata, stackMetadata, argumentCount);
    }

    private static void callWithKeywords(PythonFunctionSignature pythonFunctionSignature, FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount) {
        int i;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Type[] descriptorParameterTypes = pythonFunctionSignature.getMethodDescriptor().getParameterTypes();
        if (argumentCount < descriptorParameterTypes.length && pythonFunctionSignature.getDefaultArgumentHolderClassInternalName() == null) {
            throw new IllegalStateException("Cannot call " + String.valueOf(pythonFunctionSignature) + " because there are not enough arguments");
        }
        if (argumentCount > descriptorParameterTypes.length && pythonFunctionSignature.getExtraPositionalArgumentsVariableIndex().isEmpty() && pythonFunctionSignature.getExtraKeywordArgumentsVariableIndex().isEmpty()) {
            throw new IllegalStateException("Cannot call " + String.valueOf(pythonFunctionSignature) + " because there are too many arguments");
        }
        KnownCallImplementor.unwrapBoundMethod(pythonFunctionSignature, functionMetadata, stackMetadata, argumentCount + 1);
        if (pythonFunctionSignature.isClassMethod()) {
            ++argumentCount;
        }
        methodVisitor.visitTypeInsn(187, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName());
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeTuple.class), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitLdcInsn((Object)argumentCount);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(100);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitMethodInsn(183, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.INT_TYPE}), false);
        for (i = 0; i < argumentCount; ++i) {
            methodVisitor.visitInsn(90);
            methodVisitor.visitInsn(95);
            if (pythonFunctionSignature.isClassMethod() && i == argumentCount - 1) {
                methodVisitor.visitInsn(89);
                Label ifIsBoundFunction = new Label();
                Label doneGettingType = new Label();
                methodVisitor.visitTypeInsn(193, Type.getInternalName(BoundPythonLikeFunction.class));
                methodVisitor.visitJumpInsn(154, ifIsBoundFunction);
                methodVisitor.visitInsn(89);
                methodVisitor.visitTypeInsn(193, Type.getInternalName(PythonLikeType.class));
                methodVisitor.visitJumpInsn(154, doneGettingType);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
                methodVisitor.visitJumpInsn(167, doneGettingType);
                methodVisitor.visitLabel(ifIsBoundFunction);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(BoundPythonLikeFunction.class));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
                methodVisitor.visitLabel(doneGettingType);
            }
            methodVisitor.visitMethodInsn(182, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName(), "addArgument", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class)}), false);
        }
        for (i = 0; i < descriptorParameterTypes.length; ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(180, pythonFunctionSignature.getDefaultArgumentHolderClassInternalName(), PythonDefaultArgumentImplementor.getArgumentName(i), descriptorParameterTypes[i].getDescriptor());
            methodVisitor.visitInsn(95);
        }
        methodVisitor.visitInsn(87);
        pythonFunctionSignature.getMethodDescriptor().callMethod(methodVisitor);
    }

    public static void callUnpackListAndMap(String defaultArgumentHolderClassInternalName, MethodDescriptor methodDescriptor, MethodVisitor methodVisitor) {
        Type[] descriptorParameterTypes = methodDescriptor.getParameterTypes();
        if (methodDescriptor.getMethodType() == MethodDescriptor.MethodType.CLASS) {
            StackManipulationImplementor.rotateThree(methodVisitor);
            StackManipulationImplementor.swap(methodVisitor);
            methodVisitor.visitInsn(91);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
            methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeType.class));
            methodVisitor.visitInsn(92);
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(95);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(Object.class)}), true);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(95);
        }
        methodVisitor.visitFieldInsn(178, defaultArgumentHolderClassInternalName, "argumentSpec", Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "extractArgumentList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
        if (methodDescriptor.getMethodType() == MethodDescriptor.MethodType.VIRTUAL || methodDescriptor.getMethodType() == MethodDescriptor.MethodType.INTERFACE) {
            methodVisitor.visitInsn(95);
            methodVisitor.visitInsn(90);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoundPythonLikeFunction.class), "getInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
            methodVisitor.visitTypeInsn(192, methodDescriptor.getDeclaringClassInternalName());
            methodVisitor.visitInsn(95);
        }
        for (int i = 0; i < descriptorParameterTypes.length; ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
            methodVisitor.visitLdcInsn((Object)descriptorParameterTypes[i]);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "coerceToType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(Class.class)}), false);
            methodVisitor.visitTypeInsn(192, descriptorParameterTypes[i].getInternalName());
            methodVisitor.visitInsn(95);
        }
        methodVisitor.visitInsn(87);
        methodDescriptor.callMethod(methodVisitor);
    }
}

