/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.CompareOp;
import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonTernaryOperator;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.NotImplemented;
import ai.timefold.jpyinterpreter.types.PythonKnownFunctionType;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DunderOperatorImplementor {
    public static void unaryOperator(MethodVisitor methodVisitor, StackMetadata stackMetadata, PythonUnaryOperator operator) {
        PythonLikeType operand = Optional.ofNullable(stackMetadata.getTOSType()).orElse(BuiltinTypes.BASE_TYPE);
        Optional<PythonKnownFunctionType> maybeKnownFunctionType = operand.getMethodType(operator.getDunderMethod());
        if (maybeKnownFunctionType.isPresent()) {
            PythonKnownFunctionType knownFunctionType = maybeKnownFunctionType.get();
            Optional<PythonFunctionSignature> maybeFunctionSignature = knownFunctionType.getFunctionForParameters(new PythonLikeType[0]);
            if (maybeFunctionSignature.isPresent()) {
                PythonFunctionSignature functionSignature = maybeFunctionSignature.get();
                MethodDescriptor methodDescriptor = functionSignature.getMethodDescriptor();
                if (methodDescriptor.getParameterTypes().length < 1) {
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getDeclaringClassInternalName());
                } else {
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[0].getInternalName());
                }
                functionSignature.getMethodDescriptor().callMethod(methodVisitor);
            } else {
                DunderOperatorImplementor.unaryOperator(methodVisitor, operator);
            }
        } else {
            DunderOperatorImplementor.unaryOperator(methodVisitor, operator);
        }
    }

    public static void unaryOperator(MethodVisitor methodVisitor, PythonUnaryOperator operator) {
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)operator.getDunderMethod());
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(87);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonLikeList.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonLikeList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void binaryOperator(MethodVisitor methodVisitor, StackMetadata stackMetadata, PythonBinaryOperator operator) {
        DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator, true, true, false);
    }

    private static void binaryOperator(MethodVisitor methodVisitor, StackMetadata stackMetadata, PythonBinaryOperator operator, boolean isLeft, boolean leftCheckSuccessful, boolean forceFallback) {
        Optional<PythonKnownFunctionType> maybeKnownFunctionType;
        PythonLikeType leftOperand = Optional.ofNullable(stackMetadata.getTypeAtStackIndex(1)).orElse(BuiltinTypes.BASE_TYPE);
        PythonLikeType rightOperand = Optional.ofNullable(stackMetadata.getTypeAtStackIndex(0)).orElse(BuiltinTypes.BASE_TYPE);
        PythonBinaryOperator actualOperator = operator;
        if (forceFallback || !isLeft && operator.getFallbackOperation().isPresent()) {
            actualOperator = operator.getFallbackOperation().get();
        }
        Optional<PythonKnownFunctionType> optional = maybeKnownFunctionType = isLeft ? leftOperand.getMethodType(actualOperator.getDunderMethod()) : rightOperand.getMethodType(actualOperator.getRightDunderMethod());
        if (maybeKnownFunctionType.isEmpty() && operator.getFallbackOperation().isPresent()) {
            maybeKnownFunctionType = isLeft ? leftOperand.getMethodType(operator.getFallbackOperation().get().getDunderMethod()) : rightOperand.getMethodType(operator.getFallbackOperation().get().getRightDunderMethod());
            actualOperator = operator.getFallbackOperation().get();
        }
        if (maybeKnownFunctionType.isPresent()) {
            Optional<PythonFunctionSignature> maybeFunctionSignature;
            PythonKnownFunctionType knownFunctionType = maybeKnownFunctionType.get();
            Optional<PythonFunctionSignature> optional2 = maybeFunctionSignature = isLeft ? knownFunctionType.getFunctionForParameters(rightOperand) : knownFunctionType.getFunctionForParameters(leftOperand);
            if (maybeFunctionSignature.isPresent()) {
                boolean needToCheckForNotImplemented;
                PythonFunctionSignature functionSignature = maybeFunctionSignature.get();
                MethodDescriptor methodDescriptor = functionSignature.getMethodDescriptor();
                boolean bl = needToCheckForNotImplemented = (actualOperator.hasRightDunderMethod() || actualOperator.getFallbackOperation().isPresent()) && BuiltinTypes.NOT_IMPLEMENTED_TYPE.isSubclassOf(functionSignature.getReturnType());
                if (isLeft) {
                    if (methodDescriptor.getParameterTypes().length < 2) {
                        methodVisitor.visitInsn(95);
                        methodVisitor.visitTypeInsn(192, methodDescriptor.getDeclaringClassInternalName());
                        methodVisitor.visitInsn(95);
                        methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[0].getInternalName());
                    } else {
                        methodVisitor.visitInsn(95);
                        methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[0].getInternalName());
                        methodVisitor.visitInsn(95);
                        methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[1].getInternalName());
                    }
                } else if (methodDescriptor.getParameterTypes().length < 2) {
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[0].getInternalName());
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getDeclaringClassInternalName());
                } else {
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[1].getInternalName());
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[0].getInternalName());
                }
                if (needToCheckForNotImplemented) {
                    methodVisitor.visitInsn(92);
                }
                if (!isLeft) {
                    methodVisitor.visitInsn(95);
                }
                functionSignature.getMethodDescriptor().callMethod(methodVisitor);
                if (needToCheckForNotImplemented) {
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitFieldInsn(178, Type.getInternalName(NotImplemented.class), "INSTANCE", Type.getDescriptor(NotImplemented.class));
                    Label ifNotImplemented = new Label();
                    Label done = new Label();
                    methodVisitor.visitJumpInsn(165, ifNotImplemented);
                    methodVisitor.visitInsn(91);
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitInsn(88);
                    methodVisitor.visitJumpInsn(167, done);
                    methodVisitor.visitLabel(ifNotImplemented);
                    if (isLeft) {
                        methodVisitor.visitInsn(87);
                        if (actualOperator.getFallbackOperation().isPresent()) {
                            DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator, true, true, true);
                        } else {
                            DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator, false, true, false);
                        }
                    } else {
                        methodVisitor.visitInsn(87);
                        DunderOperatorImplementor.raiseUnsupportedType(methodVisitor, stackMetadata.localVariableHelper, operator);
                    }
                    methodVisitor.visitLabel(done);
                }
            } else if (isLeft && actualOperator.hasRightDunderMethod()) {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator, false, false, false);
            } else if (!isLeft && leftCheckSuccessful) {
                DunderOperatorImplementor.binaryOperatorOnlyRight(methodVisitor, stackMetadata.localVariableHelper, actualOperator);
            } else {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata.localVariableHelper, operator);
            }
        } else if (isLeft && actualOperator.hasRightDunderMethod()) {
            DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator, false, false, false);
        } else if (!isLeft && leftCheckSuccessful) {
            DunderOperatorImplementor.binaryOperatorOnlyRight(methodVisitor, stackMetadata.localVariableHelper, actualOperator);
        } else {
            DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata.localVariableHelper, operator);
        }
    }

    private static void raiseUnsupportedType(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, PythonBinaryOperator operator) {
        int right = localVariableHelper.newLocal();
        int left = localVariableHelper.newLocal();
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), left);
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), right);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(TypeError.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        if (!operator.getOperatorSymbol().isEmpty()) {
            methodVisitor.visitLdcInsn((Object)("unsupported operand type(s) for " + operator.getOperatorSymbol() + ": '"));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), left);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "getTypeName", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitLdcInsn((Object)"' and '");
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), right);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "getTypeName", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitLdcInsn((Object)"'");
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
            localVariableHelper.freeLocal();
            localVariableHelper.freeLocal();
            methodVisitor.visitMethodInsn(183, Type.getInternalName(TypeError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitInsn(191);
        } else {
            localVariableHelper.freeLocal();
            localVariableHelper.freeLocal();
            switch (operator) {
                default: 
            }
            methodVisitor.visitInsn(87);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(TypeError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
            methodVisitor.visitInsn(191);
        }
    }

    public static void binaryOperator(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, PythonBinaryOperator operator) {
        Label noLeftMethod = new Label();
        methodVisitor.visitInsn(92);
        if (operator.hasRightDunderMethod() || operator.getFallbackOperation().isPresent()) {
            methodVisitor.visitInsn(92);
        }
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)operator.getDunderMethod());
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitJumpInsn(165, noLeftMethod);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonLikeList.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonLikeList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(NotImplemented.class), "INSTANCE", Type.getDescriptor(NotImplemented.class));
        Label ifNotImplemented = new Label();
        Label done = new Label();
        methodVisitor.visitJumpInsn(165, ifNotImplemented);
        if (operator.hasRightDunderMethod() || operator.getFallbackOperation().isPresent()) {
            methodVisitor.visitInsn(91);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(88);
        }
        methodVisitor.visitJumpInsn(167, done);
        methodVisitor.visitLabel(noLeftMethod);
        methodVisitor.visitInsn(88);
        methodVisitor.visitLabel(ifNotImplemented);
        methodVisitor.visitInsn(87);
        Label raiseError = new Label();
        if (operator.getFallbackOperation().isPresent()) {
            DunderOperatorImplementor.binaryOperator(methodVisitor, localVariableHelper, operator.getFallbackOperation().get());
            methodVisitor.visitJumpInsn(167, done);
        } else if (operator.hasRightDunderMethod()) {
            Label noRightMethod = new Label();
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
            methodVisitor.visitLdcInsn((Object)operator.getRightDunderMethod());
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(1);
            methodVisitor.visitJumpInsn(165, noRightMethod);
            methodVisitor.visitInsn(91);
            methodVisitor.visitInsn(87);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonLikeList.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonLikeList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
            DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
            DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(178, Type.getInternalName(NotImplemented.class), "INSTANCE", Type.getDescriptor(NotImplemented.class));
            methodVisitor.visitJumpInsn(166, done);
            methodVisitor.visitInsn(87);
            methodVisitor.visitJumpInsn(167, raiseError);
            methodVisitor.visitLabel(noRightMethod);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(88);
        }
        methodVisitor.visitLabel(raiseError);
        methodVisitor.visitInsn(95);
        DunderOperatorImplementor.raiseUnsupportedType(methodVisitor, localVariableHelper, operator);
        methodVisitor.visitLabel(done);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(88);
    }

    public static void binaryOperatorOnlyRight(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, PythonBinaryOperator operator) {
        Label done = new Label();
        Label raiseError = new Label();
        Label noRightMethod = new Label();
        methodVisitor.visitInsn(92);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)operator.getRightDunderMethod());
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitJumpInsn(165, noRightMethod);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonLikeList.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonLikeList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(NotImplemented.class), "INSTANCE", Type.getDescriptor(NotImplemented.class));
        methodVisitor.visitJumpInsn(166, done);
        methodVisitor.visitInsn(87);
        methodVisitor.visitJumpInsn(167, raiseError);
        methodVisitor.visitLabel(noRightMethod);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(88);
        methodVisitor.visitLabel(raiseError);
        methodVisitor.visitInsn(95);
        DunderOperatorImplementor.raiseUnsupportedType(methodVisitor, localVariableHelper, operator);
        methodVisitor.visitLabel(done);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(88);
    }

    public static void ternaryOperator(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonTernaryOperator operator) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.rotateThree(methodVisitor);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)operator.getDunderMethod());
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        StackManipulationImplementor.rotateFour(functionMetadata, stackMetadata.pop(3).push(stackMetadata.getValueSourceForStackIndex(0)).push(stackMetadata.getValueSourceForStackIndex(1)).push(stackMetadata.getValueSourceForStackIndex(2)).pushTemp(BuiltinTypes.FUNCTION_TYPE));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonLikeList.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonLikeList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        DunderOperatorImplementor.pushArgumentIntoList(methodVisitor);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    private static void pushArgumentIntoList(MethodVisitor methodVisitor) {
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        methodVisitor.visitInsn(87);
    }

    public static void compareValues(MethodVisitor methodVisitor, StackMetadata stackMetadata, CompareOp op) {
        switch (op) {
            case LESS_THAN: {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, PythonBinaryOperator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, PythonBinaryOperator.LESS_THAN_OR_EQUAL);
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: {
                DunderOperatorImplementor.binaryOpOverridingLeftIfSpecific(methodVisitor, stackMetadata, op);
                break;
            }
            case GREATER_THAN: {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, PythonBinaryOperator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, PythonBinaryOperator.GREATER_THAN_OR_EQUAL);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled branch: " + String.valueOf((Object)op));
            }
        }
    }

    private static void binaryOpOverridingLeftIfSpecific(MethodVisitor methodVisitor, StackMetadata stackMetadata, CompareOp op) {
        PythonBinaryOperator operator;
        switch (op) {
            case EQUALS: 
            case NOT_EQUALS: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Should only be called for equals and not equals");
            }
        }
        PythonBinaryOperator pythonBinaryOperator = operator = op == CompareOp.EQUALS ? PythonBinaryOperator.EQUAL : PythonBinaryOperator.NOT_EQUAL;
        if (stackMetadata.getTypeAtStackIndex(1).getDefiningTypeOrNull(operator.getDunderMethod()) != BuiltinTypes.BASE_TYPE) {
            DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata, operator);
            return;
        }
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(90);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)operator.getDunderMethod());
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "getDefiningTypeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(BuiltinTypes.class), "BASE_TYPE", Type.getDescriptor(PythonLikeType.class));
        Label ifDefined = new Label();
        methodVisitor.visitJumpInsn(166, ifDefined);
        methodVisitor.visitInsn(95);
        methodVisitor.visitLabel(ifDefined);
        DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata.localVariableHelper, operator);
    }

    public static void getSlice(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonSlice.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonSlice.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class)}), false);
        DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata.pop(3).pushTemps(stackMetadata.getTypeAtStackIndex(2), BuiltinTypes.SLICE_TYPE), PythonBinaryOperator.GET_ITEM);
    }

    public static void storeSlice(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonSlice.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonSlice.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class)}), false);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        DunderOperatorImplementor.ternaryOperator(functionMetadata, stackMetadata.pop(4).pushTemps(stackMetadata.getTypeAtStackIndex(2), BuiltinTypes.SLICE_TYPE, stackMetadata.getTypeAtStackIndex(3)), PythonTernaryOperator.SET_ITEM);
        methodVisitor.visitInsn(87);
    }
}

