/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import java.util.Objects;

public final class PythonVersion
implements Comparable<PythonVersion> {
    private final int hexversion;
    public static final PythonVersion PYTHON_3_10 = new PythonVersion(3, 10);
    public static final PythonVersion PYTHON_3_11 = new PythonVersion(3, 11);
    public static final PythonVersion PYTHON_3_12 = new PythonVersion(3, 12);
    public static final PythonVersion MINIMUM_PYTHON_VERSION = PYTHON_3_10;

    public PythonVersion(int hexversion) {
        this.hexversion = hexversion;
    }

    public PythonVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public PythonVersion(int major, int minor, int micro) {
        this((major << 24) + (minor << 16) + (micro << 8) + 240);
    }

    public int getMajorVersion() {
        return (this.hexversion & 0xFF000000) >> 24;
    }

    public int getMinorVersion() {
        return (this.hexversion & 0xFF0000) >> 16;
    }

    public int getMicroVersion() {
        return (this.hexversion & 0xFF00) >> 8;
    }

    public int getReleaseLevel() {
        return (this.hexversion & 0xF0) >> 4;
    }

    public int getReleaseSerial() {
        return this.hexversion & 0xF;
    }

    @Override
    public int compareTo(PythonVersion pythonVersion) {
        return this.hexversion - pythonVersion.hexversion;
    }

    public boolean isBefore(PythonVersion release) {
        return this.compareTo(release) < 0;
    }

    public boolean isAfter(PythonVersion release) {
        return this.compareTo(release) > 0;
    }

    public boolean isAtLeast(PythonVersion release) {
        return this.compareTo(release) >= 0;
    }

    public boolean isBetween(PythonVersion afterInclusive, PythonVersion beforeInclusive) {
        return this.compareTo(afterInclusive) >= 0 && this.compareTo(beforeInclusive) <= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonVersion that = (PythonVersion)o;
        return this.hexversion == that.hexversion;
    }

    public int hashCode() {
        return Objects.hash(this.hexversion);
    }

    public String toString() {
        return this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getMinorVersion() + this.getReleaseLevelString() + this.getReleaseSerial();
    }

    private String getReleaseLevelString() {
        switch (this.getReleaseLevel()) {
            case 10: {
                return "a";
            }
            case 11: {
                return "b";
            }
            case 12: {
                return "rc";
            }
            case 15: {
                return "";
            }
        }
        return "<" + this.getReleaseLevel() + ">";
    }
}

