/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

public final class ByteCharSequence
implements CharSequence {
    private final byte[] data;
    private final int inclusiveStartIndex;
    private final int exclusiveEndIndex;

    public ByteCharSequence(byte[] data) {
        this.data = data;
        this.inclusiveStartIndex = 0;
        this.exclusiveEndIndex = data.length;
    }

    public ByteCharSequence(byte[] data, int inclusiveStartIndex, int exclusiveEndIndex) {
        this.data = data;
        this.inclusiveStartIndex = inclusiveStartIndex;
        this.exclusiveEndIndex = exclusiveEndIndex;
    }

    @Override
    public int length() {
        return this.exclusiveEndIndex - this.inclusiveStartIndex;
    }

    @Override
    public char charAt(int i) {
        return (char)(this.data[this.inclusiveStartIndex + i] & 0xFF);
    }

    @Override
    public ByteCharSequence subSequence(int from, int to) {
        return new ByteCharSequence(this.data, this.inclusiveStartIndex + from, this.inclusiveStartIndex + to);
    }

    @Override
    public String toString() {
        char[] chars = new char[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            chars[i] = this.charAt(i);
        }
        return String.valueOf(chars);
    }
}

