/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.wrappers;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.wrappers.JavaObjectWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiDispatchJavaMethodReference
implements PythonLikeFunction {
    private final List<Method> methodList = new ArrayList<Method>();

    public void addMethod(Method method) {
        this.methodList.add(method);
    }

    public Method getNoArgsMethod() {
        for (Method method : this.methodList) {
            if (method.getParameterCount() != 0) continue;
            return method;
        }
        throw new TypeError();
    }

    @Override
    public PythonLikeObject $call(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> namedArguments, PythonLikeObject callerInstance) {
        for (Method method : this.methodList) {
            Object[] args;
            Object self;
            if (Modifier.isStatic(method.getModifiers())) {
                if (method.getParameterCount() != positionalArguments.size()) continue;
                self = null;
                try {
                    args = this.unwrapPrimitiveArguments(method, positionalArguments);
                }
                catch (TypeError e) {
                    continue;
                }
            }
            if (method.getParameterCount() + 1 != positionalArguments.size()) continue;
            self = positionalArguments.get(0);
            if (self instanceof JavaObjectWrapper) {
                self = ((JavaObjectWrapper)self).getWrappedObject();
            }
            try {
                args = this.unwrapPrimitiveArguments(method, positionalArguments.subList(1, positionalArguments.size()));
            }
            catch (TypeError e) {
                continue;
            }
            try {
                return JavaPythonTypeConversionImplementor.wrapJavaObject(method.invoke(self, args));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method (" + String.valueOf(method) + ") is not accessible.", e);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getCause();
            }
        }
        throw new TypeError("No method with matching signature found for %s in method list %s.".formatted(positionalArguments, this.methodList));
    }

    private Object[] unwrapPrimitiveArguments(Method method, List<PythonLikeObject> positionalArguments) {
        Object[] out = new Object[method.getParameterCount()];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < positionalArguments.size(); ++i) {
            PythonLikeObject argument = positionalArguments.get(i);
            out[i] = JavaPythonTypeConversionImplementor.convertPythonObjectToJavaType(parameterTypes[i], argument);
        }
        return out;
    }

    @Override
    public PythonLikeType $getType() {
        if (Modifier.isStatic(this.methodList.get(0).getModifiers())) {
            return BuiltinTypes.STATIC_FUNCTION_TYPE;
        }
        return BuiltinTypes.FUNCTION_TYPE;
    }
}

