/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.numeric;

import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.numeric.PythonNumber;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.util.List;

public class PythonComplex
extends AbstractPythonLikeObject
implements PythonNumber,
PlanningImmutable {
    final PythonNumber real;
    final PythonNumber imaginary;
    public static final PythonLikeType COMPLEX_TYPE = new PythonLikeType("complex", PythonComplex.class, List.of(NUMBER_TYPE));

    public PythonComplex(PythonNumber real, PythonNumber imaginary) {
        super(COMPLEX_TYPE);
        this.real = real;
        this.imaginary = imaginary;
    }

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        return COMPLEX_TYPE;
    }

    public PythonComplex valueOf(PythonNumber real, PythonNumber imaginary) {
        return new PythonComplex(real, imaginary);
    }

    @Override
    public Number getValue() {
        return this.real.getValue().doubleValue() * this.real.getValue().doubleValue() + this.imaginary.getValue().doubleValue() * this.imaginary.getValue().doubleValue();
    }

    public PythonNumber getReal() {
        return this.real;
    }

    public PythonNumber getImaginary() {
        return this.imaginary;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonComplex::registerMethods);
    }
}

