/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections.view;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeSet;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

public class DictKeyView
extends AbstractPythonLikeObject {
    public static final PythonLikeType $TYPE = BuiltinTypes.DICT_KEY_VIEW_TYPE;
    final PythonLikeDict mapping;
    final Set<PythonLikeObject> keySet;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, DictKeyView.class.getMethod("getKeysSize", new Class[0]));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, DictKeyView.class.getMethod("getKeysIterator", new Class[0]));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.REVERSED, DictKeyView.class.getMethod("getReversedKeyIterator", new Class[0]));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, DictKeyView.class.getMethod("toRepresentation", new Class[0]));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, DictKeyView.class.getMethod("toRepresentation", new Class[0]));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, DictKeyView.class.getMethod("containsKey", PythonLikeObject.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addMethod("isdisjoint", DictKeyView.class.getMethod("isDisjoint", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, DictKeyView.class.getMethod("isSubset", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN, DictKeyView.class.getMethod("isStrictSubset", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, DictKeyView.class.getMethod("isSuperset", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN, DictKeyView.class.getMethod("isStrictSuperset", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.OR, DictKeyView.class.getMethod("union", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.AND, DictKeyView.class.getMethod("intersection", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, DictKeyView.class.getMethod("difference", DictKeyView.class));
        BuiltinTypes.DICT_KEY_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.XOR, DictKeyView.class.getMethod("symmetricDifference", DictKeyView.class));
        return BuiltinTypes.DICT_KEY_VIEW_TYPE;
    }

    public DictKeyView(PythonLikeDict mapping) {
        super(BuiltinTypes.DICT_KEY_VIEW_TYPE);
        this.mapping = mapping;
        this.keySet = mapping.delegate.keySet();
        this.$setAttribute("mapping", mapping);
    }

    public PythonInteger getKeysSize() {
        return PythonInteger.valueOf(this.keySet.size());
    }

    public DelegatePythonIterator<PythonLikeObject> getKeysIterator() {
        return new DelegatePythonIterator<PythonLikeObject>(this.keySet.iterator());
    }

    public PythonBoolean containsKey(PythonLikeObject key) {
        return PythonBoolean.valueOf(this.keySet.contains(key));
    }

    public DelegatePythonIterator<PythonLikeObject> getReversedKeyIterator() {
        return this.mapping.reversed();
    }

    public PythonBoolean isDisjoint(DictKeyView other) {
        return PythonBoolean.valueOf(Collections.disjoint(this.keySet, other.keySet));
    }

    public PythonBoolean isSubset(DictKeyView other) {
        return PythonBoolean.valueOf(other.keySet.containsAll(this.keySet));
    }

    public PythonBoolean isStrictSubset(DictKeyView other) {
        return PythonBoolean.valueOf(other.keySet.containsAll(this.keySet) && !this.keySet.containsAll(other.keySet));
    }

    public PythonBoolean isSuperset(DictKeyView other) {
        return PythonBoolean.valueOf(this.keySet.containsAll(other.keySet));
    }

    public PythonBoolean isStrictSuperset(DictKeyView other) {
        return PythonBoolean.valueOf(this.keySet.containsAll(other.keySet) && !other.keySet.containsAll(this.keySet));
    }

    public PythonLikeSet union(DictKeyView other) {
        PythonLikeSet out = new PythonLikeSet();
        out.delegate.addAll(this.keySet);
        out.delegate.addAll(other.keySet);
        return out;
    }

    public PythonLikeSet intersection(DictKeyView other) {
        PythonLikeSet out = new PythonLikeSet();
        out.delegate.addAll(this.keySet);
        out.delegate.retainAll(other.keySet);
        return out;
    }

    public PythonLikeSet difference(DictKeyView other) {
        PythonLikeSet out = new PythonLikeSet();
        out.delegate.addAll(this.keySet);
        out.delegate.removeAll(other.keySet);
        return out;
    }

    public PythonLikeSet symmetricDifference(DictKeyView other) {
        PythonLikeSet out = new PythonLikeSet();
        out.delegate.addAll(this.keySet);
        other.keySet.stream().filter(Predicate.not(e -> out.delegate.add(e))).forEach(out.delegate::remove);
        return out;
    }

    public boolean equals(Object o) {
        if (o instanceof DictKeyView) {
            DictKeyView other = (DictKeyView)o;
            return this.keySet.equals(other.keySet);
        }
        return false;
    }

    public int hashCode() {
        return this.keySet.hashCode();
    }

    public PythonString toRepresentation() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder("dict_keys([");
        for (PythonLikeObject key : this.keySet) {
            out.append(UnaryDunderBuiltin.REPRESENTATION.invoke(key));
            out.append(", ");
        }
        out.delete(out.length() - 2, out.length());
        out.append("])");
        return out.toString();
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(DictKeyView::registerMethods);
    }
}

