/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonTernaryOperator;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;

public class PythonLikeList<T>
extends AbstractPythonLikeObject
implements List<T>,
PlanningCloneable<PythonLikeList<T>>,
RandomAccess {
    final List delegate;
    private int remainderToAdd;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.LIST_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.size() == 0) {
                return new PythonLikeList();
            }
            if (positionalArguments.size() == 1) {
                PythonLikeList out = new PythonLikeList();
                out.extend((PythonLikeObject)positionalArguments.get(0));
                return out;
            }
            throw new ValueError("list expects 0 or 1 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.LIST_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonLikeList.class.getMethod("length", new Class[0]));
        BuiltinTypes.LIST_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonLikeList.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.LIST_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, PythonLikeList.class.getMethod("getRepresentation", new Class[0]));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonLikeList.class.getMethod("concatToNew", PythonLikeList.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_ADD, PythonLikeList.class.getMethod("concatToSelf", PythonLikeList.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonLikeList.class.getMethod("multiplyToNew", PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_MULTIPLY, PythonLikeList.class.getMethod("multiplyToSelf", PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonLikeList.class.getMethod("getItem", PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonLikeList.class.getMethod("getSlice", PythonSlice.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.DELETE_ITEM, PythonLikeList.class.getMethod("deleteItem", PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.DELETE_ITEM, PythonLikeList.class.getMethod("deleteSlice", PythonSlice.class));
        BuiltinTypes.LIST_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonLikeList.class.getMethod("containsItem", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addTernaryMethod(PythonTernaryOperator.SET_ITEM, PythonLikeList.class.getMethod("setItem", PythonInteger.class, PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addTernaryMethod(PythonTernaryOperator.SET_ITEM, PythonLikeList.class.getMethod("setSlice", PythonSlice.class, PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("append", PythonLikeList.class.getMethod("append", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("extend", PythonLikeList.class.getMethod("extend", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("insert", PythonLikeList.class.getMethod("insert", PythonInteger.class, PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("remove", PythonLikeList.class.getMethod("remove", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("clear", PythonLikeList.class.getMethod("clearList", new Class[0]));
        BuiltinTypes.LIST_TYPE.addMethod("copy", PythonLikeList.class.getMethod("copy", new Class[0]));
        BuiltinTypes.LIST_TYPE.addMethod("count", PythonLikeList.class.getMethod("count", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("index", PythonLikeList.class.getMethod("index", PythonLikeObject.class));
        BuiltinTypes.LIST_TYPE.addMethod("index", PythonLikeList.class.getMethod("index", PythonLikeObject.class, PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addMethod("index", PythonLikeList.class.getMethod("index", PythonLikeObject.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addMethod("pop", PythonLikeList.class.getMethod("pop", new Class[0]));
        BuiltinTypes.LIST_TYPE.addMethod("pop", PythonLikeList.class.getMethod("pop", PythonInteger.class));
        BuiltinTypes.LIST_TYPE.addMethod("reverse", PythonLikeList.class.getMethod("reverse", new Class[0]));
        BuiltinTypes.LIST_TYPE.addMethod("sort", PythonLikeList.class.getMethod("sort", new Class[0]));
        return BuiltinTypes.LIST_TYPE;
    }

    public PythonLikeList() {
        super(BuiltinTypes.LIST_TYPE);
        this.delegate = new ArrayList();
        this.remainderToAdd = 0;
    }

    public PythonLikeList(int size) {
        super(BuiltinTypes.LIST_TYPE);
        this.delegate = new ArrayList(size);
        this.remainderToAdd = size;
        for (int i = 0; i < size; ++i) {
            this.delegate.add(null);
        }
    }

    public PythonLikeList(List delegate) {
        super(BuiltinTypes.LIST_TYPE);
        this.delegate = delegate;
        this.remainderToAdd = 0;
    }

    public PythonLikeList<T> createNewInstance() {
        return new PythonLikeList<T>();
    }

    public void reverseAdd(PythonLikeObject object) {
        this.delegate.set(this.remainderToAdd - 1, object);
        --this.remainderToAdd;
    }

    public DelegatePythonIterator getIterator() {
        return new DelegatePythonIterator(this.delegate.iterator());
    }

    public PythonLikeList copy() {
        PythonLikeList<T> copy = new PythonLikeList<T>();
        copy.addAll((Collection)this.delegate);
        return copy;
    }

    public PythonLikeList concatToNew(PythonLikeList other) {
        PythonLikeList<T> result = new PythonLikeList<T>();
        result.addAll((Collection)this.delegate);
        result.addAll((Collection)other);
        return result;
    }

    public PythonLikeList concatToSelf(PythonLikeList other) {
        this.addAll((Collection)other);
        return this;
    }

    public PythonLikeList multiplyToNew(PythonInteger times) {
        if (times.value.compareTo(BigInteger.ZERO) <= 0) {
            return new PythonLikeList<T>();
        }
        PythonLikeList<T> result = new PythonLikeList<T>();
        int timesAsInt = times.value.intValueExact();
        for (int i = 0; i < timesAsInt; ++i) {
            result.addAll((Collection)this.delegate);
        }
        return result;
    }

    public PythonLikeList multiplyToSelf(PythonInteger times) {
        if (times.value.compareTo(BigInteger.ZERO) <= 0) {
            this.delegate.clear();
            return this;
        }
        ArrayList copy = new ArrayList(this.delegate);
        int timesAsInt = times.value.intValueExact() - 1;
        for (int i = 0; i < timesAsInt; ++i) {
            this.delegate.addAll(copy);
        }
        return this;
    }

    public PythonInteger length() {
        return PythonInteger.valueOf(this.delegate.size());
    }

    public PythonInteger index(PythonLikeObject item) {
        int result = this.delegate.indexOf(item);
        if (result != -1) {
            return PythonInteger.valueOf(result);
        }
        throw new ValueError(String.valueOf(item) + " is not in list");
    }

    public PythonInteger index(PythonLikeObject item, PythonInteger start) {
        List searchList;
        int result;
        int startAsInt = start.value.intValueExact();
        if (startAsInt < 0) {
            startAsInt = this.delegate.size() + startAsInt;
        }
        if ((result = (searchList = this.delegate.subList(startAsInt, this.delegate.size())).indexOf(item)) != -1) {
            return PythonInteger.valueOf(startAsInt + result);
        }
        throw new ValueError(String.valueOf(item) + " is not in list");
    }

    public PythonInteger index(PythonLikeObject item, PythonInteger start, PythonInteger end) {
        List searchList;
        int result;
        int startAsInt = start.value.intValueExact();
        int endAsInt = end.value.intValueExact();
        if (startAsInt < 0) {
            startAsInt = this.delegate.size() + startAsInt;
        }
        if (endAsInt < 0) {
            endAsInt = this.delegate.size() + endAsInt;
        }
        if ((result = (searchList = this.delegate.subList(startAsInt, endAsInt)).indexOf(item)) != -1) {
            return PythonInteger.valueOf(startAsInt + result);
        }
        throw new ValueError(String.valueOf(item) + " is not in list");
    }

    public PythonLikeObject getItem(PythonInteger index) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            indexAsInt = this.delegate.size() + index.value.intValueExact();
        }
        if (indexAsInt < 0 || indexAsInt >= this.delegate.size()) {
            throw new IndexError("list index out of range");
        }
        return (PythonLikeObject)this.delegate.get(indexAsInt);
    }

    public PythonLikeList getSlice(PythonSlice slice) {
        int length = this.delegate.size();
        PythonLikeList<T> out = new PythonLikeList<T>();
        slice.iterate(length, (i, processed) -> out.add(this.delegate.get(i)));
        return out;
    }

    public PythonLikeObject setItem(PythonInteger index, PythonLikeObject value) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            indexAsInt = this.delegate.size() + index.value.intValueExact();
        }
        if (indexAsInt < 0 || indexAsInt >= this.delegate.size()) {
            throw new IndexError("list index out of range");
        }
        this.delegate.set(indexAsInt, value);
        return PythonNone.INSTANCE;
    }

    public PythonLikeObject setSlice(PythonSlice slice, PythonLikeObject iterable) {
        int length = this.delegate.size();
        int start = slice.getStartIndex(length);
        int stop = slice.getStopIndex(length);
        int step = slice.getStrideLength();
        Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
        if (step == 1) {
            this.delegate.subList(start, stop).clear();
            int offset = 0;
            while (iterator.hasNext()) {
                PythonLikeObject item = (PythonLikeObject)iterator.next();
                this.delegate.add(start + offset, item);
                ++offset;
            }
        } else {
            ArrayList temp = new ArrayList();
            iterator.forEachRemaining(temp::add);
            if (temp.size() != slice.getSliceSize(length)) {
                throw new ValueError("attempt to assign sequence of size " + temp.size() + " to extended slice of size " + slice.getSliceSize(length));
            }
            slice.iterate(length, (i, processed) -> this.delegate.set(i, temp.get(processed)));
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone deleteItem(PythonInteger index) {
        if (index.value.compareTo(BigInteger.ZERO) < 0) {
            this.delegate.remove(this.delegate.size() + index.value.intValueExact());
        } else {
            this.delegate.remove(index.value.intValueExact());
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone deleteSlice(PythonSlice slice) {
        int length = this.delegate.size();
        int start = slice.getStartIndex(length);
        int stop = slice.getStopIndex(length);
        int step = slice.getStrideLength();
        if (step == 1) {
            this.delegate.subList(start, stop).clear();
        } else if (step > 0) {
            slice.iterate(length, (i, processed) -> this.delegate.remove(i - processed));
        } else {
            slice.iterate(length, (i, processed) -> this.delegate.remove(i));
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone remove(PythonLikeObject item) {
        if (!this.delegate.remove(item)) {
            throw new ValueError("list.remove(x): x not in list");
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone insert(PythonInteger index, PythonLikeObject item) {
        int indexAsInt = PythonSlice.asIntIndexForLength(index, this.delegate.size());
        if (indexAsInt < 0) {
            indexAsInt = 0;
        }
        if (indexAsInt > this.delegate.size()) {
            indexAsInt = this.delegate.size();
        }
        this.delegate.add(indexAsInt, item);
        return PythonNone.INSTANCE;
    }

    public PythonLikeObject pop() {
        if (this.delegate.isEmpty()) {
            throw new IndexError("pop from empty list");
        }
        return (PythonLikeObject)this.delegate.remove(this.delegate.size() - 1);
    }

    public PythonLikeObject pop(PythonInteger index) {
        if (this.delegate.isEmpty()) {
            throw new IndexError("pop from empty list");
        }
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            indexAsInt = this.delegate.size() + indexAsInt;
        }
        if (indexAsInt >= this.delegate.size() || indexAsInt < 0) {
            throw new IndexError("pop index out of range");
        }
        return (PythonLikeObject)this.delegate.remove(indexAsInt);
    }

    public PythonBoolean containsItem(PythonLikeObject item) {
        return PythonBoolean.valueOf(this.delegate.contains(item));
    }

    public PythonInteger count(PythonLikeObject search) {
        long count = 0L;
        for (Object x : this.delegate) {
            if (!Objects.equals(search, x)) continue;
            ++count;
        }
        return new PythonInteger(count);
    }

    public PythonNone append(PythonLikeObject item) {
        this.delegate.add(item);
        return PythonNone.INSTANCE;
    }

    public PythonNone extend(PythonLikeObject item) {
        if (item instanceof Collection) {
            this.delegate.addAll((List)((Object)item));
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(item));
            iterator.forEachRemaining(this::add);
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone reverse() {
        Collections.reverse(this.delegate);
        return PythonNone.INSTANCE;
    }

    public PythonNone sort() {
        Collections.sort(this.delegate);
        return PythonNone.INSTANCE;
    }

    public PythonNone clearList() {
        this.delegate.clear();
        return PythonNone.INSTANCE;
    }

    public PythonString getRepresentation() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean add(Object pythonLikeObject) {
        return this.delegate.add(pythonLikeObject);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int i, Collection collection) {
        return this.delegate.addAll(i, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public T get(int i) {
        return (T)this.delegate.get(i);
    }

    @Override
    public Object set(int i, Object pythonLikeObject) {
        return this.delegate.set(i, pythonLikeObject);
    }

    @Override
    public void add(int i, Object pythonLikeObject) {
        this.delegate.add(i, pythonLikeObject);
    }

    @Override
    public T remove(int i) {
        return (T)this.delegate.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.delegate.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return this.delegate.subList(i, i1);
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('[');
        for (int i = 0; i < this.delegate.size() - 1; ++i) {
            out.append(UnaryDunderBuiltin.REPRESENTATION.invoke((PythonLikeObject)this.delegate.get(i)));
            out.append(", ");
        }
        if (!this.delegate.isEmpty()) {
            out.append(UnaryDunderBuiltin.REPRESENTATION.invoke((PythonLikeObject)this.delegate.get(this.delegate.size() - 1)));
        }
        out.append(']');
        return out.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof List) {
            List other = (List)o;
            if (other.size() != this.delegate.size()) {
                return false;
            }
            int itemCount = this.delegate.size();
            for (int i = 0; i < itemCount; ++i) {
                if (Objects.equals(this.get(i), other.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public List getDelegate() {
        return this.delegate;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonLikeList::registerMethods);
    }
}

