/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PythonKnownFunctionType
extends PythonLikeType {
    final List<PythonFunctionSignature> overloadFunctionSignatureList;

    public PythonKnownFunctionType(String methodName, List<PythonFunctionSignature> overloadFunctionSignatureList) {
        super("function-" + methodName, PythonKnownFunctionType.class, List.of(BuiltinTypes.FUNCTION_TYPE));
        this.overloadFunctionSignatureList = overloadFunctionSignatureList;
    }

    public List<PythonFunctionSignature> getOverloadFunctionSignatureList() {
        return this.overloadFunctionSignatureList;
    }

    public boolean isStaticMethod() {
        return this.overloadFunctionSignatureList.get(0).getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.STATIC;
    }

    public boolean isClassMethod() {
        return this.overloadFunctionSignatureList.get(0).getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.CLASS;
    }

    @Override
    public PythonLikeType $getType() {
        return BuiltinTypes.BASE_TYPE;
    }

    @Override
    public PythonLikeType $getGenericType() {
        return BuiltinTypes.BASE_TYPE;
    }

    public Optional<PythonFunctionSignature> getDefaultFunctionSignature() {
        return this.overloadFunctionSignatureList.stream().findAny();
    }

    public Optional<PythonFunctionSignature> getFunctionForParameters(PythonLikeType ... parameters) {
        List matchingOverloads = this.overloadFunctionSignatureList.stream().filter(signature -> signature.matchesParameters(parameters)).collect(Collectors.toList());
        if (matchingOverloads.isEmpty()) {
            return Optional.empty();
        }
        PythonFunctionSignature best = (PythonFunctionSignature)matchingOverloads.get(0);
        for (PythonFunctionSignature signature2 : matchingOverloads) {
            if (!signature2.moreSpecificThan(best)) continue;
            best = signature2;
        }
        return Optional.of(best);
    }

    public Optional<PythonFunctionSignature> getFunctionForParameters(int positionalItemCount, List<String> keywordNames, List<PythonLikeType> callStackTypeList) {
        List matchingOverloads = this.overloadFunctionSignatureList.stream().filter(signature -> signature.matchesParameters(positionalItemCount, keywordNames, callStackTypeList)).collect(Collectors.toList());
        if (matchingOverloads.isEmpty()) {
            return Optional.empty();
        }
        PythonFunctionSignature best = (PythonFunctionSignature)matchingOverloads.get(0);
        for (PythonFunctionSignature signature2 : matchingOverloads) {
            if (!signature2.moreSpecificThan(best)) continue;
            best = signature2;
        }
        return Optional.of(best);
    }
}

