/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.variable;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.VariableImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.wrappers.CPythonType;
import ai.timefold.jpyinterpreter.types.wrappers.PythonObjectWrapper;

public class LoadGlobalOpcode
extends AbstractOpcode {
    public LoadGlobalOpcode(PythonBytecodeInstruction instruction) {
        super(instruction);
    }

    private int getGlobalIndex(FunctionMetadata functionMetadata) {
        return functionMetadata.pythonCompiledFunction.pythonVersion.compareTo(PythonVersion.PYTHON_3_11) >= 0 ? this.instruction.arg() >> 1 : this.instruction.arg();
    }

    private boolean pushNullBeforeGlobal(FunctionMetadata functionMetadata) {
        return functionMetadata.pythonCompiledFunction.pythonVersion.compareTo(PythonVersion.PYTHON_3_11) >= 0 && (this.instruction.arg() & 1) == 1;
    }

    private PythonLikeObject getGlobal(FunctionMetadata functionMetadata) {
        return functionMetadata.pythonCompiledFunction.globalsMap.get(functionMetadata.pythonCompiledFunction.co_names.get(this.getGlobalIndex(functionMetadata)));
    }

    @Override
    protected StackMetadata getStackMetadataAfterInstruction(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        boolean pushNull = this.pushNullBeforeGlobal(functionMetadata);
        PythonLikeObject global = this.getGlobal(functionMetadata);
        if (pushNull) {
            if (global != null) {
                return stackMetadata.push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.NULL_TYPE, new ValueSourceInfo[0])).push(ValueSourceInfo.of((Opcode)this, global.$getGenericType(), new ValueSourceInfo[0]));
            }
            return stackMetadata.push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.NULL_TYPE, new ValueSourceInfo[0])).push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
        }
        if (global != null) {
            return stackMetadata.push(ValueSourceInfo.of((Opcode)this, global.$getGenericType(), new ValueSourceInfo[0]));
        }
        return stackMetadata.push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
    }

    @Override
    public void implement(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        int globalIndex = this.getGlobalIndex(functionMetadata);
        boolean pushNull = this.pushNullBeforeGlobal(functionMetadata);
        PythonLikeObject global = this.getGlobal(functionMetadata);
        if (global instanceof CPythonType || global instanceof PythonObjectWrapper) {
            // empty if block
        }
        if (pushNull) {
            functionMetadata.methodVisitor.visitInsn(1);
        }
        VariableImplementor.loadGlobalVariable(functionMetadata, stackMetadata, globalIndex, global != null ? global.$getGenericType() : BuiltinTypes.BASE_TYPE);
    }
}

