/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.function;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.FunctionImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeGenericType;
import ai.timefold.jpyinterpreter.types.PythonLikeType;

public class LoadMethodOpcode
extends AbstractOpcode {
    public LoadMethodOpcode(PythonBytecodeInstruction instruction) {
        super(instruction);
    }

    @Override
    protected StackMetadata getStackMetadataAfterInstruction(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        PythonLikeType stackTosType = stackMetadata.getTOSType();
        PythonLikeType tosType = stackTosType instanceof PythonLikeGenericType ? ((PythonLikeGenericType)stackTosType).getOrigin() : stackTosType;
        return tosType.getMethodType(functionMetadata.pythonCompiledFunction.co_names.get(this.instruction.arg())).map(knownFunction -> stackMetadata.pop().push(ValueSourceInfo.of((Opcode)this, (PythonLikeType)knownFunction, stackMetadata.getValueSourcesUpToStackIndex(1))).push(ValueSourceInfo.of((Opcode)this, tosType, stackMetadata.getValueSourcesUpToStackIndex(1)))).orElseGet(() -> stackMetadata.pop().push(ValueSourceInfo.of((Opcode)this, PythonLikeFunction.getFunctionType(), stackMetadata.getValueSourcesUpToStackIndex(1))).push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.NULL_TYPE, stackMetadata.getValueSourcesUpToStackIndex(1))));
    }

    @Override
    public void implement(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        FunctionImplementor.loadMethod(functionMetadata, stackMetadata, this.instruction.arg());
    }
}

