/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.controlflow;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.JumpImplementor;
import ai.timefold.jpyinterpreter.opcodes.controlflow.AbstractControlFlowOpcode;
import java.util.List;

public class JumpIfNotExcMatchOpcode
extends AbstractControlFlowOpcode {
    int jumpTarget;

    public JumpIfNotExcMatchOpcode(PythonBytecodeInstruction instruction, int jumpTarget) {
        super(instruction);
        this.jumpTarget = jumpTarget;
    }

    @Override
    public List<Integer> getPossibleNextBytecodeIndexList() {
        return List.of(Integer.valueOf(this.getBytecodeIndex() + 1), Integer.valueOf(this.jumpTarget));
    }

    @Override
    public List<StackMetadata> getStackMetadataAfterInstructionForBranches(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        return List.of(stackMetadata.pop(2), stackMetadata.pop(2));
    }

    @Override
    public void implement(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        JumpImplementor.popAndJumpIfExceptionDoesNotMatch(functionMetadata, stackMetadata, this.jumpTarget);
    }
}

