/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.DunderOperatorImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JumpImplementor {
    public static void jumpAbsolute(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        methodVisitor.visitJumpInsn(167, jumpLocation);
    }

    public static void popAndJumpIfTrue(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        if (stackMetadata.getTOSType() != BuiltinTypes.BOOLEAN_TYPE) {
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.AS_BOOLEAN);
        }
        PythonConstantsImplementor.loadTrue(methodVisitor);
        methodVisitor.visitJumpInsn(165, jumpLocation);
    }

    public static void popAndJumpIfFalse(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        if (stackMetadata.getTOSType() != BuiltinTypes.BOOLEAN_TYPE) {
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.AS_BOOLEAN);
        }
        PythonConstantsImplementor.loadFalse(methodVisitor);
        methodVisitor.visitJumpInsn(165, jumpLocation);
    }

    public static void popAndJumpIfIsNotNone(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        PythonConstantsImplementor.loadNone(methodVisitor);
        methodVisitor.visitJumpInsn(166, jumpLocation);
    }

    public static void popAndJumpIfIsNone(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        PythonConstantsImplementor.loadNone(methodVisitor);
        methodVisitor.visitJumpInsn(165, jumpLocation);
    }

    public static void popAndJumpIfExceptionDoesNotMatch(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeType.class));
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "isSubclassOf", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(PythonLikeType.class)}), false);
        methodVisitor.visitJumpInsn(153, jumpLocation);
    }

    public static void jumpIfTrueElsePop(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        methodVisitor.visitInsn(89);
        if (stackMetadata.getTOSType() != BuiltinTypes.BOOLEAN_TYPE) {
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.AS_BOOLEAN);
        }
        PythonConstantsImplementor.loadTrue(methodVisitor);
        methodVisitor.visitJumpInsn(165, jumpLocation);
        methodVisitor.visitInsn(87);
    }

    public static void jumpIfFalseElsePop(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int jumpTarget) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Label jumpLocation = bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        methodVisitor.visitInsn(89);
        if (stackMetadata.getTOSType() != BuiltinTypes.BOOLEAN_TYPE) {
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.AS_BOOLEAN);
        }
        PythonConstantsImplementor.loadFalse(methodVisitor);
        methodVisitor.visitJumpInsn(165, jumpLocation);
        methodVisitor.visitInsn(87);
    }
}

