/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.PythonCompiledClass;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DelegatingInterfaceImplementor
extends JavaInterfaceImplementor {
    final String internalClassName;
    final Class<?> interfaceClass;
    final Map<String, PythonClassTranslator.InterfaceDeclaration> methodNameToFieldDescriptor;

    public DelegatingInterfaceImplementor(String internalClassName, Class<?> interfaceClass, Map<String, PythonClassTranslator.InterfaceDeclaration> methodNameToFieldDescriptor) {
        this.internalClassName = internalClassName;
        this.interfaceClass = interfaceClass;
        this.methodNameToFieldDescriptor = methodNameToFieldDescriptor;
    }

    @Override
    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public void implement(ClassWriter classWriter, PythonCompiledClass compiledClass) {
        for (Method method : this.interfaceClass.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getDeclaringClass().isInterface()) continue;
            this.implementMethod(classWriter, compiledClass, method);
        }
    }

    private void implementMethod(ClassWriter classWriter, PythonCompiledClass compiledClass, Method interfaceMethod) {
        if (!this.methodNameToFieldDescriptor.containsKey(interfaceMethod.getName())) {
            if (interfaceMethod.isDefault()) {
                return;
            }
            throw new TypeError("Class %s cannot implement interface %s because it does not implement method %s.".formatted(compiledClass.className, interfaceMethod.getDeclaringClass().getName(), interfaceMethod.getName()));
        }
        String interfaceMethodDescriptor = Type.getMethodDescriptor((Method)interfaceMethod);
        MethodVisitor interfaceMethodVisitor = classWriter.visitMethod(1, interfaceMethod.getName(), interfaceMethodDescriptor, null, null);
        interfaceMethodVisitor = MethodVisitorAdapters.adapt(interfaceMethodVisitor, interfaceMethod.getName(), interfaceMethodDescriptor);
        for (Parameter parameter : interfaceMethod.getParameters()) {
            interfaceMethodVisitor.visitParameter(parameter.getName(), 0);
        }
        interfaceMethodVisitor.visitCode();
        interfaceMethodVisitor.visitVarInsn(25, 0);
        interfaceMethodVisitor.visitTypeInsn(187, Type.getInternalName(IdentityHashMap.class));
        interfaceMethodVisitor.visitInsn(89);
        interfaceMethodVisitor.visitMethodInsn(183, Type.getInternalName(IdentityHashMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitVarInsn(58, interfaceMethod.getParameterCount() + 1);
        PythonClassTranslator.InterfaceDeclaration functionInterfaceDeclaration = this.methodNameToFieldDescriptor.get(interfaceMethod.getName());
        interfaceMethodVisitor.visitVarInsn(25, 0);
        interfaceMethodVisitor.visitFieldInsn(178, this.internalClassName, PythonClassTranslator.getJavaMethodHolderName(interfaceMethod.getName()), functionInterfaceDeclaration.descriptor());
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitLdcInsn((Object)"__spec__");
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Class.class), "getField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        interfaceMethodVisitor.visitFieldInsn(178, this.internalClassName, PythonClassTranslator.getJavaMethodHolderName(interfaceMethod.getName()), functionInterfaceDeclaration.descriptor());
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Field.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}), false);
        interfaceMethodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        Type methodType = functionInterfaceDeclaration.methodType();
        int argumentCount = methodType.getArgumentCount();
        DelegatingInterfaceImplementor.prepareParametersForMethodCallFromArgumentSpec(interfaceMethod, interfaceMethodVisitor, argumentCount, methodType, true);
        Type[] javaParameterTypes = new Type[Math.max(0, argumentCount - 1)];
        for (int i = 1; i < argumentCount; ++i) {
            javaParameterTypes[i - 1] = methodType.getArgumentTypes()[i];
        }
        Type methodReturnType = PythonClassTranslator.getVirtualFunctionReturnType(compiledClass.instanceFunctionNameToPythonBytecode.get(interfaceMethod.getName()));
        String javaMethodDescriptor = Type.getMethodDescriptor((Type)methodReturnType, (Type[])javaParameterTypes);
        interfaceMethodVisitor.visitMethodInsn(182, this.internalClassName, PythonClassTranslator.getJavaMethodName(interfaceMethod.getName()), javaMethodDescriptor, false);
        Class<?> returnType = interfaceMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            interfaceMethodVisitor.visitInsn(177);
        } else {
            if (returnType.isPrimitive()) {
                JavaPythonTypeConversionImplementor.loadTypeClass(returnType, interfaceMethodVisitor);
            } else {
                interfaceMethodVisitor.visitLdcInsn((Object)Type.getType(returnType));
            }
            interfaceMethodVisitor.visitInsn(95);
            interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "convertPythonObjectToJavaType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(PythonLikeObject.class)}), false);
            if (returnType.isPrimitive()) {
                JavaPythonTypeConversionImplementor.unboxBoxedPrimitiveType(returnType, interfaceMethodVisitor);
                interfaceMethodVisitor.visitInsn(Type.getType(returnType).getOpcode(172));
            } else {
                interfaceMethodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
                interfaceMethodVisitor.visitInsn(176);
            }
        }
        interfaceMethodVisitor.visitMaxs(interfaceMethod.getParameterCount() + 2, 1);
        interfaceMethodVisitor.visitEnd();
    }

    public static void prepareParametersForMethodCallFromArgumentSpec(Method interfaceMethod, MethodVisitor interfaceMethodVisitor, int argumentCount, Type methodType, boolean skipSelf) {
        int i;
        int parameterStart = skipSelf ? 1 : 0;
        interfaceMethodVisitor.visitLdcInsn((Object)interfaceMethod.getParameterCount());
        interfaceMethodVisitor.visitTypeInsn(189, Type.getInternalName(PythonLikeObject.class));
        interfaceMethodVisitor.visitVarInsn(58, interfaceMethod.getParameterCount() + 2);
        for (i = 0; i < interfaceMethod.getParameterCount(); ++i) {
            Class<?> parameterType = interfaceMethod.getParameterTypes()[i];
            interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 2);
            interfaceMethodVisitor.visitLdcInsn((Object)i);
            interfaceMethodVisitor.visitVarInsn(Type.getType(parameterType).getOpcode(21), i + 1);
            if (parameterType.isPrimitive()) {
                JavaPythonTypeConversionImplementor.boxPrimitiveType(parameterType, interfaceMethodVisitor);
            }
            interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 1);
            interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "wrapJavaObject", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Map.class)}), false);
            interfaceMethodVisitor.visitInsn(83);
        }
        interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 2);
        interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(List.class), "of", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(Object[].class)}), true);
        interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "extractArgumentList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
        for (i = 0; i < argumentCount - parameterStart; ++i) {
            interfaceMethodVisitor.visitInsn(89);
            interfaceMethodVisitor.visitLdcInsn((Object)i);
            interfaceMethodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
            interfaceMethodVisitor.visitTypeInsn(192, methodType.getArgumentTypes()[i + parameterStart].getInternalName());
            interfaceMethodVisitor.visitInsn(95);
        }
        interfaceMethodVisitor.visitInsn(87);
    }
}

