/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonTernaryOperator;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.implementors.DunderOperatorImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonBuiltinOperatorImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.StopIteration;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CollectionImplementor {
    public static void iterateIterator(MethodVisitor methodVisitor, int jumpTarget, StackMetadata stackMetadata, FunctionMetadata functionMetadata) {
        Label tryStartLabel = new Label();
        Label tryEndLabel = new Label();
        Label catchStartLabel = new Label();
        Label catchEndLabel = new Label();
        Label loopEndLabel = functionMetadata.bytecodeCounterToLabelMap.computeIfAbsent(jumpTarget, key -> new Label());
        int[] storedStack = StackManipulationImplementor.storeStack(methodVisitor, stackMetadata);
        methodVisitor.visitTryCatchBlock(tryStartLabel, tryEndLabel, catchStartLabel, Type.getInternalName(StopIteration.class));
        methodVisitor.visitLabel(tryStartLabel);
        methodVisitor.visitInsn(89);
        DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.NEXT);
        methodVisitor.visitLabel(tryEndLabel);
        methodVisitor.visitJumpInsn(167, catchEndLabel);
        methodVisitor.visitLabel(catchStartLabel);
        methodVisitor.visitInsn(87);
        methodVisitor.visitJumpInsn(167, loopEndLabel);
        methodVisitor.visitLabel(catchEndLabel);
        functionMetadata.bytecodeCounterToCodeArgumenterList.computeIfAbsent(jumpTarget, key -> new ArrayList()).add(() -> {
            StackManipulationImplementor.restoreStack(methodVisitor, stackMetadata, storedStack);
            methodVisitor.visitInsn(87);
        });
    }

    public static void unpackSequence(MethodVisitor methodVisitor, int toUnpack, LocalVariableHelper localVariableHelper) {
        int i;
        int sizeLocal = localVariableHelper.newLocal();
        methodVisitor.visitInsn(3);
        localVariableHelper.writeTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        int[] unpackedLocals = new int[toUnpack];
        for (int i2 = 0; i2 < toUnpack; ++i2) {
            unpackedLocals[i2] = localVariableHelper.newLocal();
            methodVisitor.visitInsn(1);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i2]);
        }
        DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.ITERATOR);
        Label tryStartLabel = new Label();
        Label tryEndLabel = new Label();
        Label finallyStartLabel = new Label();
        methodVisitor.visitTryCatchBlock(tryStartLabel, tryEndLabel, finallyStartLabel, null);
        methodVisitor.visitLabel(tryStartLabel);
        for (int i3 = 0; i3 < toUnpack + 1; ++i3) {
            methodVisitor.visitInsn(89);
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.NEXT);
            if (i3 < toUnpack) {
                localVariableHelper.writeTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i3]);
            } else {
                methodVisitor.visitInsn(87);
            }
            localVariableHelper.incrementTemp(methodVisitor, sizeLocal);
        }
        methodVisitor.visitLabel(tryEndLabel);
        methodVisitor.visitLabel(finallyStartLabel);
        Label toFewElements = new Label();
        Label toManyElements = new Label();
        Label exactNumberOfElements = new Label();
        methodVisitor.visitInsn(87);
        localVariableHelper.readTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        methodVisitor.visitLdcInsn((Object)toUnpack);
        methodVisitor.visitJumpInsn(161, toFewElements);
        localVariableHelper.readTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        methodVisitor.visitLdcInsn((Object)toUnpack);
        methodVisitor.visitJumpInsn(163, toManyElements);
        methodVisitor.visitJumpInsn(167, exactNumberOfElements);
        methodVisitor.visitLabel(toFewElements);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("not enough values to unpack (expected " + toUnpack + ", got "));
        methodVisitor.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        localVariableHelper.readTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.INT_TYPE}), false);
        methodVisitor.visitLdcInsn((Object)")");
        methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(toManyElements);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("too many values to unpack (expected " + toUnpack + ")"));
        methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(exactNumberOfElements);
        for (i = toUnpack - 1; i >= 0; --i) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i]);
        }
        localVariableHelper.freeLocal();
        for (i = 0; i < toUnpack; ++i) {
            localVariableHelper.freeLocal();
        }
    }

    public static void unpackSequenceWithTail(MethodVisitor methodVisitor, int toUnpack, LocalVariableHelper localVariableHelper) {
        int i;
        int sizeLocal = localVariableHelper.newLocal();
        methodVisitor.visitInsn(3);
        localVariableHelper.writeTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        int[] unpackedLocals = new int[toUnpack];
        for (int i2 = 0; i2 < toUnpack; ++i2) {
            unpackedLocals[i2] = localVariableHelper.newLocal();
            methodVisitor.visitInsn(1);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i2]);
        }
        int tailLocal = localVariableHelper.newLocal();
        CollectionImplementor.buildCollection(PythonLikeList.class, methodVisitor, 0);
        localVariableHelper.writeTemp(methodVisitor, Type.getType(Object.class), tailLocal);
        DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.ITERATOR);
        Label tryStartLabel = new Label();
        Label tryEndLabel = new Label();
        Label finallyStartLabel = new Label();
        methodVisitor.visitTryCatchBlock(tryStartLabel, tryEndLabel, finallyStartLabel, null);
        methodVisitor.visitLabel(tryStartLabel);
        for (int i3 = 0; i3 < toUnpack; ++i3) {
            methodVisitor.visitInsn(89);
            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.NEXT);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i3]);
            localVariableHelper.incrementTemp(methodVisitor, sizeLocal);
        }
        Label tailLoopStart = new Label();
        methodVisitor.visitLabel(tailLoopStart);
        methodVisitor.visitInsn(89);
        DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.NEXT);
        localVariableHelper.readTemp(methodVisitor, Type.getType(Object.class), tailLocal);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitJumpInsn(167, tailLoopStart);
        methodVisitor.visitLabel(tryEndLabel);
        methodVisitor.visitLabel(finallyStartLabel);
        Label exactNumberOfElements = new Label();
        methodVisitor.visitInsn(87);
        localVariableHelper.readTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        methodVisitor.visitLdcInsn((Object)toUnpack);
        methodVisitor.visitJumpInsn(162, exactNumberOfElements);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("not enough values to unpack (expected " + toUnpack + ", got "));
        methodVisitor.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        localVariableHelper.readTemp(methodVisitor, Type.INT_TYPE, sizeLocal);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.INT_TYPE}), false);
        methodVisitor.visitLdcInsn((Object)")");
        methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(exactNumberOfElements);
        localVariableHelper.readTemp(methodVisitor, Type.getType(Object.class), tailLocal);
        for (i = toUnpack - 1; i >= 0; --i) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(Object.class), unpackedLocals[i]);
        }
        localVariableHelper.freeLocal();
        for (i = 0; i < toUnpack; ++i) {
            localVariableHelper.freeLocal();
        }
        localVariableHelper.freeLocal();
    }

    public static void buildCollection(Class<?> collectionType, MethodVisitor methodVisitor, int itemCount) {
        String typeInternalName = Type.getInternalName(collectionType);
        methodVisitor.visitTypeInsn(187, typeInternalName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)itemCount);
        methodVisitor.visitMethodInsn(183, typeInternalName, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        for (int i = 0; i < itemCount; ++i) {
            methodVisitor.visitInsn(90);
            methodVisitor.visitInsn(95);
            methodVisitor.visitMethodInsn(182, typeInternalName, "reverseAdd", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class)}), false);
        }
    }

    public static void convertListToTuple(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonLikeTuple.class), "fromList", Type.getMethodDescriptor((Type)Type.getType(PythonLikeTuple.class), (Type[])new Type[]{Type.getType(List.class)}), false);
    }

    public static void buildMap(Class<? extends Map> mapType, MethodVisitor methodVisitor, int itemCount) {
        String typeInternalName = Type.getInternalName(mapType);
        methodVisitor.visitTypeInsn(187, typeInternalName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, typeInternalName, "<init>", "()V", false);
        for (int i = 0; i < itemCount; ++i) {
            methodVisitor.visitInsn(91);
            StackManipulationImplementor.rotateThree(methodVisitor);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
            methodVisitor.visitInsn(87);
        }
    }

    public static void buildConstKeysMap(Class<? extends Map> mapType, MethodVisitor methodVisitor, int itemCount) {
        String typeInternalName = Type.getInternalName(mapType);
        methodVisitor.visitTypeInsn(187, typeInternalName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, typeInternalName, "<init>", "()V", false);
        for (int i = 0; i < itemCount; ++i) {
            methodVisitor.visitInsn(91);
            StackManipulationImplementor.rotateThree(methodVisitor);
            methodVisitor.visitInsn(91);
            methodVisitor.visitLdcInsn((Object)(itemCount - i - 1));
            methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Integer.TYPE)}), true);
            methodVisitor.visitInsn(95);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(95);
        }
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(87);
    }

    public static void containsOperator(MethodVisitor methodVisitor, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        StackManipulationImplementor.swap(methodVisitor);
        DunderOperatorImplementor.binaryOperator(methodVisitor, stackMetadata.pop(2).push(stackMetadata.getTOSValueSource()).push(stackMetadata.getValueSourceForStackIndex(1)), PythonBinaryOperator.CONTAINS);
        if (instruction.arg() == 1) {
            PythonBuiltinOperatorImplementor.performNotOnTOS(methodVisitor);
        }
    }

    public static void setItem(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.rotateThree(methodVisitor);
        StackManipulationImplementor.rotateThree(methodVisitor);
        DunderOperatorImplementor.ternaryOperator(functionMetadata, stackMetadata.pop(3).push(stackMetadata.getValueSourceForStackIndex(1)).push(stackMetadata.getValueSourceForStackIndex(0)).push(stackMetadata.getValueSourceForStackIndex(2)), PythonTernaryOperator.SET_ITEM);
        StackManipulationImplementor.popTOS(methodVisitor);
    }

    public static void collectionAdd(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, instruction.arg());
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        StackManipulationImplementor.popTOS(methodVisitor);
    }

    public static void collectionAddAll(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, instruction.arg());
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "addAll", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Collection.class)}), true);
        StackManipulationImplementor.popTOS(methodVisitor);
    }

    public static void mapPut(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, instruction.arg() + 1);
        StackManipulationImplementor.rotateThree(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
        StackManipulationImplementor.popTOS(methodVisitor);
    }

    public static void mapPutAll(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, instruction.arg());
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "putAll", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class)}), true);
    }

    public static void mapPutAllOnlyIfAllNewElseThrow(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, instruction.arg());
        StackManipulationImplementor.swap(methodVisitor);
        StackManipulationImplementor.duplicateTOSAndTOS1(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", Type.getMethodDescriptor((Type)Type.getType(Set.class), (Type[])new Type[0]), true);
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", Type.getMethodDescriptor((Type)Type.getType(Set.class), (Type[])new Type[0]), true);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "disjoint", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Collection.class), Type.getType(Collection.class)}), false);
        Label performPutAllLabel = new Label();
        methodVisitor.visitJumpInsn(154, performPutAllLabel);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(performPutAllLabel);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "putAll", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class)}), true);
    }

    public static void buildSlice(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argCount) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        if (argCount == 2) {
            methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonInteger.class), "ONE", Type.getDescriptor(PythonInteger.class));
        } else if (argCount != 3) {
            throw new IllegalArgumentException("arg for BUILD_SLICE must be 2 or 3");
        }
        int stepTemp = localVariableHelper.newLocal();
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), stepTemp);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonSlice.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), stepTemp);
        localVariableHelper.freeLocal();
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonSlice.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class)}), false);
    }
}

