/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.PythonExceptionTable;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.TypeHint;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.util.JavaIdentifierUtils;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.objectweb.asm.Type;

public class PythonCompiledFunction {
    public String module;
    public String moduleFilePath;
    public String qualifiedName;
    public List<PythonBytecodeInstruction> instructionList;
    public PythonLikeTuple closure;
    public Map<String, PythonLikeObject> globalsMap;
    public Map<String, TypeHint> typeAnnotations;
    public PythonLikeTuple defaultPositionalArguments = new PythonLikeTuple();
    public PythonLikeDict defaultKeywordArguments = new PythonLikeDict();
    public List<String> co_names;
    public List<String> co_varnames;
    public List<String> co_cellvars;
    public List<String> co_freevars;
    public List<PythonLikeObject> co_constants;
    public PythonExceptionTable co_exceptiontable;
    public int co_argcount;
    public int co_kwonlyargcount;
    public int co_posonlyargcount;
    public boolean supportExtraPositionalArgs = false;
    public boolean supportExtraKeywordsArgs = false;
    public PythonVersion pythonVersion;
    public PythonClassTranslator.PythonMethodKind methodKind = PythonClassTranslator.PythonMethodKind.STATIC_METHOD;

    public PythonCompiledFunction copy() {
        PythonCompiledFunction out = new PythonCompiledFunction();
        out.module = this.module;
        out.moduleFilePath = this.moduleFilePath;
        out.qualifiedName = this.qualifiedName;
        out.instructionList = List.copyOf(this.instructionList);
        out.closure = this.closure;
        out.globalsMap = this.globalsMap;
        out.typeAnnotations = this.typeAnnotations;
        out.defaultPositionalArguments = this.defaultPositionalArguments;
        out.defaultKeywordArguments = this.defaultKeywordArguments;
        out.co_exceptiontable = this.co_exceptiontable;
        out.co_names = List.copyOf(this.co_names);
        out.co_varnames = List.copyOf(this.co_varnames);
        out.co_cellvars = List.copyOf(this.co_cellvars);
        out.co_freevars = List.copyOf(this.co_freevars);
        out.co_constants = List.copyOf(this.co_constants);
        out.co_argcount = this.co_argcount;
        out.co_kwonlyargcount = this.co_kwonlyargcount;
        out.pythonVersion = this.pythonVersion;
        out.methodKind = this.methodKind;
        return out;
    }

    public List<PythonLikeType> getParameterTypes() {
        ArrayList<PythonLikeType> out = new ArrayList<PythonLikeType>(this.totalArgCount());
        PythonLikeType defaultType = BuiltinTypes.BASE_TYPE;
        for (int i = 0; i < this.totalArgCount(); ++i) {
            String parameterName = this.co_varnames.get(i);
            TypeHint parameterTypeHint = this.typeAnnotations.get(parameterName);
            PythonLikeType parameterType = defaultType;
            if (parameterTypeHint != null) {
                parameterType = parameterTypeHint.type();
            }
            out.add(parameterType);
        }
        return out;
    }

    public Optional<PythonLikeType> getReturnType() {
        TypeHint returnTypeHint = this.typeAnnotations.get("return");
        if (returnTypeHint == null) {
            return Optional.empty();
        }
        return Optional.of(returnTypeHint.type());
    }

    public Optional<TypeHint> getReturnTypeHint() {
        return Optional.ofNullable(this.typeAnnotations.get("return"));
    }

    public String getAsmMethodDescriptorString() {
        Type returnType = Type.getType((String)("L" + this.getReturnType().map(PythonLikeType::getJavaTypeInternalName).orElseGet(BuiltinTypes.BASE_TYPE::getJavaTypeInternalName) + ";"));
        List<PythonLikeType> parameterPythonTypeList = this.getParameterTypes();
        Type[] parameterTypes = new Type[this.totalArgCount()];
        for (int i = 0; i < this.totalArgCount(); ++i) {
            parameterTypes[i] = Type.getType((String)("L" + parameterPythonTypeList.get(i).getJavaTypeInternalName() + ";"));
        }
        return Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes);
    }

    public String getGeneratedClassBaseName() {
        if (this.module == null || this.module.isEmpty()) {
            return JavaIdentifierUtils.sanitizeClassName(this.qualifiedName != null ? this.qualifiedName : "PythonFunction");
        }
        return JavaIdentifierUtils.sanitizeClassName(this.qualifiedName != null ? this.module + "." + this.qualifiedName : this.module + ".PythonFunction");
    }

    private static <T> Class<T> getParameterJavaClass(List<PythonLikeType> parameterTypeList, int variableIndex) {
        return parameterTypeList.get(variableIndex).getJavaClassOrDefault(PythonLikeObject.class);
    }

    private static String getParameterJavaClassName(List<PythonLikeType> parameterTypeList, int variableIndex) {
        return parameterTypeList.get(variableIndex).getJavaTypeInternalName();
    }

    public BiFunction<PythonLikeTuple, PythonLikeDict, ArgumentSpec<PythonLikeObject>> getArgumentSpecMapper() {
        return (defaultPositionalArguments, defaultKeywordArguments) -> {
            ArgumentSpec out = ArgumentSpec.forFunctionReturning(this.qualifiedName, this.getReturnType().map(PythonLikeType::getJavaTypeInternalName).orElse(PythonLikeObject.class.getName()));
            int variableIndex = 0;
            int defaultPositionalStartIndex = this.co_argcount - defaultPositionalArguments.size();
            if (this.methodKind == PythonClassTranslator.PythonMethodKind.VIRTUAL_METHOD) {
                variableIndex = 1;
            }
            List<PythonLikeType> parameterTypeList = this.getParameterTypes();
            while (variableIndex < this.co_posonlyargcount) {
                out = variableIndex >= defaultPositionalStartIndex ? out.addPositionalOnlyArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex), defaultPositionalArguments.get(variableIndex - defaultPositionalStartIndex)) : out.addPositionalOnlyArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex));
                ++variableIndex;
            }
            while (variableIndex < this.co_argcount) {
                out = variableIndex >= defaultPositionalStartIndex ? out.addArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex), defaultPositionalArguments.get(variableIndex - defaultPositionalStartIndex)) : out.addArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex));
                ++variableIndex;
            }
            for (int i = 0; i < this.co_kwonlyargcount; ++i) {
                Object maybeDefault = defaultKeywordArguments.get(PythonString.valueOf(this.co_varnames.get(variableIndex)));
                out = maybeDefault != null ? out.addKeywordOnlyArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex), maybeDefault) : out.addKeywordOnlyArgument(this.co_varnames.get(variableIndex), PythonCompiledFunction.getParameterJavaClassName(parameterTypeList, variableIndex));
                ++variableIndex;
            }
            if (this.supportExtraPositionalArgs) {
                out = out.addExtraPositionalVarArgument(this.co_varnames.get(variableIndex));
                ++variableIndex;
            }
            if (this.supportExtraKeywordsArgs) {
                out = out.addExtraKeywordVarArgument(this.co_varnames.get(variableIndex));
            }
            return out;
        };
    }

    public int totalArgCount() {
        int extraArgs = 0;
        if (this.supportExtraPositionalArgs) {
            ++extraArgs;
        }
        if (this.supportExtraKeywordsArgs) {
            ++extraArgs;
        }
        return this.co_argcount + this.co_kwonlyargcount + extraArgs;
    }

    public int getFirstLine() {
        for (PythonBytecodeInstruction instruction : this.instructionList) {
            if (!instruction.startsLine().isPresent()) continue;
            return instruction.startsLine().getAsInt();
        }
        return -1;
    }
}

