/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariableHelper {
    public final Type[] parameters;
    public final int argcount;
    public final int parameterSlotsEnd;
    public final int pythonCellVariablesStart;
    public final int pythonFreeVariablesStart;
    public final int pythonLocalVariablesSlotEnd;
    public final int pythonBoundVariables;
    public final int pythonFreeVariables;
    public final Map<Integer, Integer> boundCellIndexToVariableIndex;
    public final int currentExceptionVariableSlot;
    public final int callKeywordsSlot;
    public final Map<Integer, Integer> exceptionTableTargetToSavedStackMap;
    int usedLocals;

    public LocalVariableHelper(Type[] parameters, PythonCompiledFunction compiledFunction) {
        this.argcount = compiledFunction.totalArgCount();
        this.parameters = parameters;
        int slotsUsedByParameters = 1;
        for (Type parameter : parameters) {
            if (parameter.equals((Object)Type.LONG_TYPE) || parameter.equals((Object)Type.DOUBLE_TYPE)) {
                slotsUsedByParameters += 2;
                continue;
            }
            ++slotsUsedByParameters;
        }
        this.pythonBoundVariables = compiledFunction.co_cellvars.size();
        this.pythonFreeVariables = compiledFunction.co_freevars.size();
        this.parameterSlotsEnd = slotsUsedByParameters;
        this.pythonCellVariablesStart = this.parameterSlotsEnd + compiledFunction.co_varnames.size();
        this.pythonFreeVariablesStart = this.pythonCellVariablesStart + this.pythonBoundVariables;
        this.currentExceptionVariableSlot = this.pythonFreeVariablesStart + this.pythonFreeVariables;
        this.callKeywordsSlot = this.currentExceptionVariableSlot + 1;
        this.exceptionTableTargetToSavedStackMap = new HashMap<Integer, Integer>();
        Iterator<Integer> iterator = compiledFunction.co_exceptiontable.getJumpTargetSet().iterator();
        while (iterator.hasNext()) {
            int target = (Integer)iterator.next();
            this.exceptionTableTargetToSavedStackMap.put(target, this.callKeywordsSlot + 1 + this.exceptionTableTargetToSavedStackMap.size());
        }
        this.pythonLocalVariablesSlotEnd = this.callKeywordsSlot + 1 + this.exceptionTableTargetToSavedStackMap.size();
        this.boundCellIndexToVariableIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < compiledFunction.co_cellvars.size(); ++i) {
            for (int j = 0; j < compiledFunction.co_varnames.size(); ++j) {
                if (!compiledFunction.co_cellvars.get(i).equals(compiledFunction.co_varnames.get(j))) continue;
                this.boundCellIndexToVariableIndex.put(i, j);
                break;
            }
            if (this.boundCellIndexToVariableIndex.containsKey(i)) continue;
            this.boundCellIndexToVariableIndex.put(i, this.pythonCellVariablesStart + i);
        }
    }

    LocalVariableHelper(Type[] parameters, int argcount, int parameterSlotsEnd, int pythonCellVariablesStart, int pythonFreeVariablesStart, int pythonLocalVariablesSlotEnd, int pythonBoundVariables, int pythonFreeVariables, Map<Integer, Integer> boundCellIndexToVariableIndex, int currentExceptionVariableSlot, int callKeywordsSlot, Map<Integer, Integer> exceptionTableTargetToSavedStackMap) {
        this.argcount = argcount;
        this.parameters = parameters;
        this.parameterSlotsEnd = parameterSlotsEnd;
        this.pythonCellVariablesStart = pythonCellVariablesStart;
        this.pythonFreeVariablesStart = pythonFreeVariablesStart;
        this.pythonLocalVariablesSlotEnd = pythonLocalVariablesSlotEnd;
        this.pythonBoundVariables = pythonBoundVariables;
        this.pythonFreeVariables = pythonFreeVariables;
        this.boundCellIndexToVariableIndex = boundCellIndexToVariableIndex;
        this.currentExceptionVariableSlot = currentExceptionVariableSlot;
        this.callKeywordsSlot = callKeywordsSlot;
        this.exceptionTableTargetToSavedStackMap = exceptionTableTargetToSavedStackMap;
    }

    public LocalVariableHelper copy() {
        LocalVariableHelper out = new LocalVariableHelper(this.parameters, this.argcount, this.parameterSlotsEnd, this.pythonCellVariablesStart, this.pythonFreeVariablesStart, this.pythonLocalVariablesSlotEnd, this.pythonBoundVariables, this.pythonFreeVariables, this.boundCellIndexToVariableIndex, this.currentExceptionVariableSlot, this.callKeywordsSlot, this.exceptionTableTargetToSavedStackMap);
        out.usedLocals = this.usedLocals;
        return out;
    }

    public int getParameterSlot(int parameterIndex) {
        if (parameterIndex > this.parameters.length) {
            throw new IndexOutOfBoundsException("Asked for the slot corresponding to the (" + parameterIndex + ") parameter, but there are only (" + this.parameters.length + ") parameters (" + Arrays.toString(this.parameters) + ").");
        }
        int slotsUsedByParameters = 1;
        for (int i = 0; i < parameterIndex; ++i) {
            if (this.parameters[i].equals((Object)Type.LONG_TYPE) || this.parameters[i].equals((Object)Type.DOUBLE_TYPE)) {
                slotsUsedByParameters += 2;
                continue;
            }
            ++slotsUsedByParameters;
        }
        return slotsUsedByParameters;
    }

    public int getPythonLocalVariableSlot(int index) {
        return this.parameterSlotsEnd + index;
    }

    public int getPythonCellOrFreeVariableSlot(int index) {
        return this.pythonCellVariablesStart + index;
    }

    public int getCurrentExceptionVariableSlot() {
        return this.currentExceptionVariableSlot;
    }

    public int getCallKeywordsSlot() {
        return this.callKeywordsSlot;
    }

    public int getNumberOfFreeCells() {
        return this.pythonFreeVariables;
    }

    public int getNumberOfBoundCells() {
        return this.pythonBoundVariables;
    }

    public int getNumberOfCells() {
        return this.pythonBoundVariables + this.pythonFreeVariables;
    }

    public int getNumberOfLocalVariables() {
        return this.pythonCellVariablesStart - this.parameterSlotsEnd;
    }

    public int newLocal() {
        int slot = this.pythonLocalVariablesSlotEnd + this.usedLocals;
        ++this.usedLocals;
        return slot;
    }

    public void freeLocal() {
        --this.usedLocals;
    }

    public int getUsedLocals() {
        return this.usedLocals;
    }

    public void readLocal(MethodVisitor methodVisitor, int local) {
        methodVisitor.visitVarInsn(25, this.getPythonLocalVariableSlot(local));
    }

    public void writeLocal(MethodVisitor methodVisitor, int local) {
        methodVisitor.visitVarInsn(58, this.getPythonLocalVariableSlot(local));
    }

    public void readCellInitialValue(MethodVisitor methodVisitor, int cell) {
        if (this.boundCellIndexToVariableIndex.containsKey(cell)) {
            int boundedVariable = this.boundCellIndexToVariableIndex.get(cell);
            if (boundedVariable >= this.argcount) {
                methodVisitor.visitInsn(1);
            } else {
                this.readLocal(methodVisitor, this.boundCellIndexToVariableIndex.get(cell));
            }
        } else {
            throw new IllegalStateException("Cannot find corresponding slot for bounded cell " + cell + " in map " + String.valueOf(this.boundCellIndexToVariableIndex));
        }
    }

    public void readCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(25, this.getPythonCellOrFreeVariableSlot(cell));
    }

    public void writeCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(58, this.getPythonCellOrFreeVariableSlot(cell));
    }

    public void writeFreeCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(58, this.pythonFreeVariablesStart + cell);
    }

    public void readCurrentException(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, this.getCurrentExceptionVariableSlot());
    }

    public void writeCurrentException(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(58, this.getCurrentExceptionVariableSlot());
    }

    public int getExceptionTableTargetStackSlot(int target) {
        return this.exceptionTableTargetToSavedStackMap.get(target);
    }

    public void readExceptionTableTargetStack(MethodVisitor methodVisitor, int target) {
        methodVisitor.visitVarInsn(25, this.getExceptionTableTargetStackSlot(target));
    }

    public void writeExceptionTableTargetStack(MethodVisitor methodVisitor, int target) {
        methodVisitor.visitVarInsn(58, this.getExceptionTableTargetStackSlot(target));
    }

    public void setupInitialStoredExceptionStacks(MethodVisitor methodVisitor) {
        for (Integer target : this.exceptionTableTargetToSavedStackMap.keySet()) {
            methodVisitor.visitInsn(1);
            this.writeExceptionTableTargetStack(methodVisitor, target);
        }
    }

    public void readCallKeywords(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, this.getCallKeywordsSlot());
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeTuple.class));
    }

    public void writeCallKeywords(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(58, this.getCallKeywordsSlot());
    }

    public void resetCallKeywords(MethodVisitor methodVisitor) {
        methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonLikeTuple.class), "EMPTY", Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(58, this.getCallKeywordsSlot());
    }

    public void readTemp(MethodVisitor methodVisitor, Type type, int temp) {
        methodVisitor.visitVarInsn(type.getOpcode(21), temp);
    }

    public void writeTemp(MethodVisitor methodVisitor, Type type, int temp) {
        methodVisitor.visitVarInsn(type.getOpcode(54), temp);
    }

    public void incrementTemp(MethodVisitor methodVisitor, int temp) {
        methodVisitor.visitIincInsn(temp, 1);
    }
}

