package com.particles.mes.android

import com.particles.mes.android.data.MesAdImpressionEvent
import com.particles.mes.android.data.MesAdRequest
import com.particles.mes.android.data.MesAdRequestExt
import com.particles.mes.android.data.MesAdResponse
import com.particles.mes.android.data.MesAdType
import com.particles.msp.api.AdRequest
import com.particles.msp.api.BannerAdView
import com.particles.msp.api.MSPAd
import com.particles.msp.api.NativeAd
import org.prebid.mobile.rendering.bidding.data.bid.Bid
import org.prebid.mobile.rendering.models.openrtb.BidRequest

object MesTrackerExt {
    val tracker: MesTracker by lazy { MesTracker("https://mes.themsp.ai/") }

    fun MesTracker.trackAdImpression(adRequest: AdRequest, winnerBid: Bid?, ad: MSPAd) {
        this.trackAdImpression(
            MesAdImpressionEvent(
                adRequest = MesAdRequest(
                    sentRequestAtMillis = 0L,
                    bidRequest = winnerBid?.let { BidRequest().apply { id = it.requestId } },
                    ext = MesAdRequestExt(
                        source = adRequest.placementId,
                        position = adRequest.customParams["position"]?.toString()?.toIntOrNull() ?: 0,
                        placementId = ad.adInfo["bidder_placement_id"]?.toString() ?: adRequest.placementId,
                        buckets = listOf(),
                        adSlotId = adRequest.customParams["ad_slot_id"] as? String ?: "",
                        userId = adRequest.customParams["user_id"] as? String ?: "",
                    )
                ),
                adResponse = MesAdResponse(
                    receivedResponseAtMillis = ad.adInfo["ad_loaded_at"] as? Long ?: 0L,
                    adType = when (ad) {
                        is BannerAdView -> MesAdType.AD_TYPE_DISPLAY
                        is NativeAd -> MesAdType.AD_TYPE_NATIVE
                        else -> MesAdType.AD_TYPE_UNSPECIFIED
                    },
                    bid = winnerBid,
                    title = (ad as? NativeAd)?.title,
                    body = (ad as? NativeAd)?.body,
                    advertiser = (ad as? NativeAd)?.advertiser,
                ),
            )
        )
    }
}


