package com.particles.mes.android.data

import com.particles.mes.protos.ErrorCode

data class MesAdImpressionEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val mspSdkVersion: String,
)

data class MesAdHideEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val reason: String,
    val mspSdkVersion: String,
)

data class MesAdReportEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val reason: String,
    val description: String? = null,
    val mspSdkVersion: String,
)

data class MesSdkInitEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val org: String,
    val app: String,
    val latency: Int,
    val totalCompleteTime: Int,
    val completeTimeByAdNetwork: Map<String, Int>,
    val mspSdkVersion: String,
)

data class MesLoadAdEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest?,
    val adResponse: MesAdResponse?,
    val org: String,
    val app: String,
    val latency: Int,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val filledFromCache: Boolean = false,
    val mspSdkVersion: String,
)

data class MesGetAdEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val mspSdkVersion: String,
)

data class MesAdRequestEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val mspSdkVersion: String,
)

data class MesAdResponseEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse?,
    val latency: Int,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val mspSdkVersion: String,
)

data class MesAdClickEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val mspSdkVersion: String,
)
