/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import org.apache.commons.lang.math.IEEE754rUtils;
import water.util.comparison.string.StringComparator;

public class LevenshteinDistanceComparator
implements StringComparator {
    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0;
        }
        return 1.0 - this.distance(a, b) / (double)Math.max(a.length(), b.length());
    }

    private double distance(String a, String b) {
        int i;
        if (a.isEmpty()) {
            return b.length();
        }
        if (b.isEmpty()) {
            return a.length();
        }
        if (a.equals(b)) {
            return 0.0;
        }
        int aLength = b.length();
        int bLength = a.length();
        double[] v0 = new double[aLength + 1];
        double[] v1 = new double[aLength + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = (double)i * 1.0;
        }
        for (i = 0; i < bLength; ++i) {
            v1[0] = (double)(i + 1) * 1.0;
            for (int j = 0; j < aLength; ++j) {
                v1[j + 1] = IEEE754rUtils.min(v1[j] + 1.0, v0[j + 1] + 1.0, v0[j] + (a.charAt(i) == b.charAt(j) ? 0.0 : 1.0));
            }
            double[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return v0[aLength];
    }
}

