/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class ParseTime {
    public static DateTimeFormatter forStrptimePattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Empty date time pattern specification");
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        ParseTime.parseToBuilder(builder, pattern);
        DateTimeFormatter formatter = builder.toFormatter();
        return formatter;
    }

    private static void parseToBuilder(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        block33: for (int i = 0; i < length; ++i) {
            indexRef[0] = i;
            String token = ParseTime.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            if (c == '%' && token.charAt(1) != '%') {
                c = token.charAt(1);
                switch (c) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        continue block33;
                    }
                    case 'A': {
                        builder.appendDayOfWeekText();
                        continue block33;
                    }
                    case 'b': 
                    case 'h': {
                        builder.appendMonthOfYearShortText();
                        continue block33;
                    }
                    case 'B': {
                        builder.appendMonthOfYearText();
                        continue block33;
                    }
                    case 'c': {
                        builder.appendDayOfWeekShortText();
                        builder.appendLiteral(' ');
                        builder.appendMonthOfYearShortText();
                        builder.appendLiteral(' ');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral(' ');
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendYear(4, 4);
                        continue block33;
                    }
                    case 'C': {
                        builder.appendCenturyOfEra(1, 2);
                        continue block33;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        continue block33;
                    }
                    case 'D': {
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral('/');
                        builder.appendTwoDigitYear(2019);
                        continue block33;
                    }
                    case 'e': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendDayOfMonth(2);
                        continue block33;
                    }
                    case 'F': {
                        builder.appendYear(4, 4);
                        builder.appendLiteral('-');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('-');
                        builder.appendDayOfMonth(2);
                        continue block33;
                    }
                    case 'G': 
                    case 'g': {
                        continue block33;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        continue block33;
                    }
                    case 'I': {
                        builder.appendClockhourOfHalfday(2);
                        continue block33;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        continue block33;
                    }
                    case 'k': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendHourOfDay(2);
                        continue block33;
                    }
                    case 'l': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendClockhourOfHalfday(2);
                        continue block33;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        continue block33;
                    }
                    case 'M': {
                        builder.appendMinuteOfHour(2);
                        continue block33;
                    }
                    case 'n': {
                        continue block33;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        continue block33;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendHalfdayOfDayText();
                        continue block33;
                    }
                    case 'R': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        continue block33;
                    }
                    case 'S': {
                        builder.appendSecondOfMinute(2);
                        continue block33;
                    }
                    case 't': {
                        continue block33;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        continue block33;
                    }
                    case 'V': {
                        continue block33;
                    }
                    case 'x': {
                        builder.appendTwoDigitYear(2019);
                        builder.appendLiteral('/');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        continue block33;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(2019);
                        continue block33;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        continue block33;
                    }
                    case 'z': {
                        builder.appendTimeZoneOffset(null, "z", false, 2, 2);
                        continue block33;
                    }
                    case 'Z': {
                        continue block33;
                    }
                    default: {
                        builder.appendLiteral('\'');
                        builder.appendLiteral(token);
                        throw new IllegalArgumentException(token + "is not acceptted as a parse token, treating as a literal");
                    }
                }
            }
            if (c == '\'') {
                String sub = token.substring(1);
                if (sub.length() <= 0) continue;
                builder.appendLiteral(new String(sub));
                continue;
            }
            throw new IllegalArgumentException("Unexpected token encountered parsing format string:" + c);
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuilder buf = new StringBuilder();
        int i = indexRef[0];
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c == '%' && i + 1 < length && pattern.charAt(i + 1) != '%') {
            if (((c = pattern.charAt(++i)) == '0' || c == 'E') && i + 1 >= length) {
                c = pattern.charAt(++i);
            }
            buf.append('%');
            buf.append(c);
        } else {
            buf.append('\'');
            buf.append(c);
            ++i;
            while (i < length) {
                c = pattern.charAt(i);
                if (c == '%') {
                    if (i + 1 >= length || pattern.charAt(i + 1) != '%') break;
                    ++i;
                }
                buf.append(c);
                ++i;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }
}

