/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.util.ArrayList;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.persist.PersistNFS;
import water.util.ArrayUtils;

public class FileIntegrityChecker
extends MRTask<FileIntegrityChecker> {
    final String[] _files;
    final long[] _sizes;
    int[] _ok;

    @Override
    public void setupLocal() {
        this._ok = new int[this._files.length];
        for (int i = 0; i < this._files.length; ++i) {
            File f = new File(this._files[i]);
            if (!f.exists() || f.length() != this._sizes[i]) continue;
            this._ok[i] = 1;
        }
    }

    @Override
    public void reduce(FileIntegrityChecker o) {
        ArrayUtils.add(this._ok, o._ok);
    }

    private void addFolder(File path, ArrayList<File> filesInProgress) {
        if (!path.canRead()) {
            return;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.canRead() || f.length() == 0L || f.isHidden() && !path.isHidden()) continue;
                if (f.isDirectory()) {
                    this.addFolder(f, filesInProgress);
                    continue;
                }
                filesInProgress.add(f);
            }
        } else if (path.length() > 0L) {
            filesInProgress.add(path);
        }
    }

    public static FileIntegrityChecker check(File r) {
        return (FileIntegrityChecker)new FileIntegrityChecker(r).doAllNodes();
    }

    public FileIntegrityChecker(File root) {
        super((byte)119);
        ArrayList<File> filesInProgress = new ArrayList<File>();
        this.addFolder(root, filesInProgress);
        this._files = new String[filesInProgress.size()];
        this._sizes = new long[filesInProgress.size()];
        for (int i = 0; i < this._files.length; ++i) {
            File f = filesInProgress.get(i);
            this._files[i] = f.getAbsolutePath();
            this._sizes[i] = f.length();
        }
    }

    public int size() {
        return this._files.length;
    }

    public Key syncDirectory(ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        Futures fs = new Futures();
        Key k = null;
        for (int i = 0; i < this._files.length; ++i) {
            if (this._ok[i] < H2O.CLOUD.size()) {
                if (fails == null) continue;
                fails.add(this._files[i]);
                continue;
            }
            File f = new File(this._files[i]);
            k = PersistNFS.decodeFile(f);
            if (files != null) {
                files.add(this._files[i]);
            }
            if (keys != null) {
                keys.add(k.toString());
            }
            if (DKV.get(k) != null) {
                dels.add(k.toString());
            }
            Key<Job> lockOwner = Key.make();
            new Frame(k).delete_and_lock((Key)lockOwner);
            NFSFileVec nfs = NFSFileVec.make(f, fs);
            ((Frame)new Frame(k, new String[]{"C1"}, new Vec[]{nfs}).update(lockOwner)).unlock(lockOwner);
        }
        fs.blockForPending();
        return k;
    }
}

