/*
 * Decompiled with CFR 0.152.
 */
package water.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

public class EncryptionTool {
    private File _keystore_file;
    private String _keystore_type;
    private String _key_alias;
    private char[] _password;
    private String _cipher_spec;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecretKeySpec readKey() {
        try (FileInputStream ksStream = new FileInputStream(this._keystore_file);){
            KeyStore keystore = KeyStore.getInstance(this._keystore_type);
            keystore.load(ksStream, this._password);
            if (!keystore.containsAlias(this._key_alias)) {
                throw new IllegalArgumentException("Key for alias='" + this._key_alias + "' not found.");
            }
            Key key = keystore.getKey(this._key_alias, this._password);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
            return secretKeySpec;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to load key '" + this._key_alias + "' from keystore '" + this._keystore_file.getAbsolutePath() + "'.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read keystore '" + this._keystore_file.getAbsolutePath() + "'.", e);
        }
    }

    public void encrypt(File input, File output) throws IOException, GeneralSecurityException {
        SecretKeySpec key = this.readKey();
        Cipher cipher = Cipher.getInstance(this._cipher_spec);
        cipher.init(1, key);
        try (FileInputStream inputStream = new FileInputStream(input);
             FileOutputStream outputStream = new FileOutputStream(output);
             CipherOutputStream cipherStream = new CipherOutputStream(outputStream, cipher);){
            IOUtils.copyLarge(inputStream, cipherStream);
        }
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        EncryptionTool.mainInternal(args);
    }

    public static void mainInternal(String[] args) throws GeneralSecurityException, IOException {
        EncryptionTool et = new EncryptionTool();
        et._keystore_file = new File(args[0]);
        et._keystore_type = args[1];
        et._key_alias = args[2];
        et._password = args[3].toCharArray();
        et._cipher_spec = args[4];
        et.encrypt(new File(args[5]), new File(args[6]));
    }
}

