/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import java.util.Arrays;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;
import water.util.Log;

public class AstDistance
extends AstBuiltin<AstDistance> {
    @Override
    public String[] args() {
        return new String[]{"ary", "x", "y", "measure"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "distance";
    }

    @Override
    public String description() {
        return "Compute a pairwise distance measure between all rows of two numeric H2OFrames.\nFor a given (usually larger) reference frame (N rows x p cols),\nand a (usually smaller) query frame (M rows x p cols), we return a numeric Frame of size (N rows x M cols),\nwhere the ij-th element is the distance measure between the i-th reference row and the j-th query row.\nNote1: The output frame is symmetric.\nNote2: Since N x M can be very large, it may be more efficient (memory-wise) to make multiple calls with smaller query Frames.";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame frx = stk.track(asts[1].exec(env)).getFrame();
        Frame fry = stk.track(asts[2].exec(env)).getFrame();
        String measure = stk.track(asts[3].exec(env)).getStr();
        return this.computeCosineDistances(frx, fry, measure);
    }

    public Val computeCosineDistances(Frame references, Frame queries, String distanceMetric) {
        Log.info("Number of references: " + references.numRows());
        Log.info("Number of queries   : " + queries.numRows());
        Object[] options = new String[]{"cosine", "cosine_sq", "l1", "l2"};
        if (!ArrayUtils.contains(options, distanceMetric.toLowerCase())) {
            throw new IllegalArgumentException("Invalid distance measure provided: " + distanceMetric + ". Mustbe one of " + Arrays.toString(options));
        }
        if (references.numRows() * queries.numRows() * 8L > H2O.CLOUD.free_mem()) {
            throw new IllegalArgumentException("Not enough free memory to allocate the distance matrix (" + references.numRows() + " rows and " + queries.numRows() + " cols. Try specifying a smaller query frame.");
        }
        if (references.numCols() != queries.numCols()) {
            throw new IllegalArgumentException("Frames must have the same number of cols, found " + references.numCols() + " and " + queries.numCols());
        }
        if (queries.numRows() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Queries can't be larger than 2 billion rows.");
        }
        if (queries.numCols() != references.numCols()) {
            throw new IllegalArgumentException("Queries and References must have the same dimensionality");
        }
        for (int i = 0; i < queries.numCols(); ++i) {
            if (!references.vec(i).isNumeric()) {
                throw new IllegalArgumentException("References column " + references.name(i) + " is not numeric.");
            }
            if (!queries.vec(i).isNumeric()) {
                throw new IllegalArgumentException("Queries column " + references.name(i) + " is not numeric.");
            }
            if (references.vec(i).naCnt() > 0L) {
                throw new IllegalArgumentException("References column " + references.name(i) + " contains missing values.");
            }
            if (queries.vec(i).naCnt() <= 0L) continue;
            throw new IllegalArgumentException("Queries column " + references.name(i) + " contains missing values.");
        }
        return new ValFrame(((DistanceComputer)new DistanceComputer(queries, distanceMetric).doAll((int)queries.numRows(), (byte)3, references)).outputFrame());
    }

    public static class DistanceComputer
    extends MRTask<DistanceComputer> {
        Frame _queries;
        String _measure;

        DistanceComputer(Frame queries, String measure) {
            this._queries = queries;
            this._measure = measure;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            int r;
            int p = cs.length;
            int Q = (int)this._queries.numRows();
            int R = cs[0]._len;
            Vec.Reader[] Qs = new Vec.Reader[p];
            for (int i = 0; i < p; ++i) {
                Qs[i] = new Vec.Reader(this._queries.vec(i));
            }
            double[] denomR = null;
            double[] denomQ = null;
            boolean cosine = this._measure.toLowerCase().equals("cosine");
            boolean cosine_sq = this._measure.toLowerCase().equals("cosine_sq");
            boolean l1 = this._measure.toLowerCase().equals("l1");
            boolean l2 = this._measure.toLowerCase().equals("l2");
            if (cosine || cosine_sq) {
                int c;
                denomR = new double[R];
                denomQ = new double[Q];
                for (r = 0; r < R; ++r) {
                    for (c = 0; c < p; ++c) {
                        int n = r;
                        denomR[n] = denomR[n] + Math.pow(cs[c].atd(r), 2.0);
                    }
                }
                for (int q = 0; q < Q; ++q) {
                    for (c = 0; c < p; ++c) {
                        int n = q;
                        denomQ[n] = denomQ[n] + Math.pow(Qs[c].at(q), 2.0);
                    }
                }
            }
            for (r = 0; r < cs[0]._len; ++r) {
                for (int q = 0; q < Q; ++q) {
                    int c;
                    double distRQ = 0.0;
                    if (l1) {
                        for (c = 0; c < p; ++c) {
                            distRQ += Math.abs(cs[c].atd(r) - Qs[c].at(q));
                        }
                    } else if (l2) {
                        for (c = 0; c < p; ++c) {
                            distRQ += Math.pow(cs[c].atd(r) - Qs[c].at(q), 2.0);
                        }
                        distRQ = Math.sqrt(distRQ);
                    } else if (cosine || cosine_sq) {
                        for (c = 0; c < p; ++c) {
                            distRQ += cs[c].atd(r) * Qs[c].at(q);
                        }
                        if (cosine_sq) {
                            distRQ *= distRQ;
                            distRQ /= denomR[r] * denomQ[q];
                        } else {
                            distRQ /= Math.sqrt(denomR[r] * denomQ[q]);
                        }
                    }
                    ncs[q].addNum(distRQ);
                }
            }
        }
    }
}

