/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.Scope;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;

public class ScopeInspect {
    public static String toString(Scope scope) {
        return ScopeInspect.toString(scope, false, false, false, k -> true);
    }

    public static String toString(Scope scope, boolean hierarchy, boolean outOfScope, boolean subKeys, Predicate<Key> keyFilter) {
        StringBuilder sb = new StringBuilder();
        HashSet<Key> scoped = new HashSet<Key>();
        sb.append("Scope").append(hierarchy ? " hierarchy" : "").append("\n");
        List<Scope.Level> levels = scope.levels();
        for (int i = levels.size() - 1; i >= 0; --i) {
            String desc;
            TreeSet<Key> ks = new TreeSet<Key>(levels.get((int)i)._keys);
            TreeSet<Key> pks = new TreeSet<Key>(levels.get((int)i)._protectedKeys);
            Map<Key, Scope.TrackingInfo> tracks = levels.get((int)i)._trackingInfo;
            scoped.addAll(ks);
            scoped.addAll(pks);
            if (hierarchy) {
                ScopeInspect.indent(sb, 1).append("level ").append(i).append(": \n");
            }
            ScopeInspect.indent(sb, 2).append("tracking ").append(ks.size()).append(" keys:\n");
            for (Key k : ks) {
                desc = tracks.containsKey(k) ? tracks.get((Object)k)._source : null;
                ScopeInspect.appendKey(sb, k, 3, desc, subKeys, keyFilter);
            }
            ScopeInspect.indent(sb, 2).append("protecting ").append(pks.size()).append(" keys:\n");
            for (Key k : pks) {
                desc = tracks.containsKey(k) ? tracks.get((Object)k)._source : null;
                ScopeInspect.appendKey(sb, k, 3, desc, subKeys, keyFilter);
            }
            if (!hierarchy) break;
        }
        if (outOfScope) {
            TreeSet<Key> unscoped = new TreeSet<Key>(((KeysCollector)new KeysCollector().doAllNodes()).keys());
            unscoped.removeAll(scoped);
            sb.append("Keys out of scope:\n");
            for (Key k : unscoped) {
                ScopeInspect.appendKey(sb, k, 1, null, subKeys, keyFilter);
            }
        }
        return sb.toString();
    }

    public static String keysToString(String header, Key ... keys) {
        StringBuilder sb = new StringBuilder(header).append(":\n");
        for (Key key : keys) {
            ScopeInspect.appendKey(sb, key, 1, null, true, k -> true);
        }
        return sb.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int numIndent) {
        int indent = 2;
        for (int i = 0; i < numIndent * 2; ++i) {
            sb.append(" ");
        }
        return sb;
    }

    private static StringBuilder appendKey(StringBuilder sb, Key key, int numIndent, String desc, boolean subKeys, Predicate<Key> keyFilter) {
        block8: {
            block7: {
                if (!keyFilter.test(key)) {
                    return sb;
                }
                ScopeInspect.indent(sb, numIndent).append(key).append(" [").append(key.valueClass()).append(desc == null ? "" : ", " + desc).append("]").append("\n");
                if (!subKeys) {
                    return sb;
                }
                if (!key.isVec()) break block7;
                Vec v = (Vec)DKV.getGet(key);
                if (v == null) break block8;
                ScopeInspect.appendKey(sb, v.rollupStatsKey(), numIndent + 1, "rollupstats", false, keyFilter);
                for (int i = 0; i < v.nChunks(); ++i) {
                    ScopeInspect.appendKey(sb, v.chunkKey(i), numIndent + 1, "chunk", false, keyFilter);
                }
                break block8;
            }
            if (key.isChunkKey()) {
                ScopeInspect.appendKey(sb, key.getVecKey(), numIndent + 1, "from vec", false, keyFilter);
            } else {
                Frame fr;
                Value v = DKV.get(key);
                if (v != null && v.isFrame() && (fr = (Frame)v.get()) != null) {
                    for (int i = 0; i < fr.keys().length; ++i) {
                        Key<Vec> vk = fr.keys()[i];
                        ScopeInspect.appendKey(sb, vk, numIndent + 1, "vec_" + i, true, keyFilter);
                    }
                }
            }
        }
        return sb;
    }

    public static String dataKeysToString() {
        return ScopeInspect.toString(Scope.current(), true, true, true, k -> {
            boolean ok;
            boolean bl = ok = k.isVec() || k.isChunkKey();
            if (ok) {
                return true;
            }
            Value v = DKV.get(k);
            if (v != null) {
                return v.isFrame();
            }
            return false;
        });
    }

    private static class KeysCollector
    extends MRTask<KeysCollector> {
        Key[] _collectedKeys;

        private KeysCollector() {
        }

        @Override
        protected void setupLocal() {
            this._collectedKeys = H2O.localKeySet().toArray(new Key[0]);
        }

        @Override
        public void reduce(KeysCollector mrt) {
            Set<Key> ks = this.keys();
            ks.addAll(mrt.keys());
            this._collectedKeys = ks.toArray(new Key[0]);
        }

        public Set<Key> keys() {
            return new HashSet<Key>(Arrays.asList(this._collectedKeys));
        }
    }
}

